/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.record;

import java.lang.reflect.Field;
import java.net.URI;
import org.dbpedia.extraction.live.record.MediawikiTitle;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.dbpedia.extraction.live.util.StringUtil;

public class RecordMetadata {
    private final String language;
    private final MediawikiTitle title;
    private final String oaiId;
    private final URI wikipediaIRI;
    private final String revision;
    private final String username;
    private final String ip;
    private final String userId;

    public RecordMetadata(String language, MediawikiTitle title, String oaiId, URI wikipediaIRI, String revision, String username, String ip, String userId) {
        this.language = language;
        this.oaiId = oaiId;
        this.wikipediaIRI = wikipediaIRI;
        this.title = title;
        this.revision = revision;
        this.username = username;
        this.ip = ip;
        this.userId = userId;
    }

    public String getLanguage() {
        return this.language;
    }

    public MediawikiTitle getTitle() {
        return this.title;
    }

    public String getOaiId() {
        return this.oaiId;
    }

    public URI getWikipediaURI() {
        return this.wikipediaIRI;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getUsername() {
        return this.username;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUserId() {
        return this.userId;
    }

    public String toString() {
        Field[] fields;
        String result = "";
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            String value = "error";
            try {
                value = StringUtil.toString(field.get(this));
            }
            catch (Exception e) {
                System.err.println(ExceptionUtil.toString(e));
            }
            result = result + field.getName() + ": " + value + "\n";
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RecordMetadata)) {
            return false;
        }
        RecordMetadata other = (RecordMetadata)o;
        return this.getOaiId().equals(other.getOaiId());
    }

    public int hashCode() {
        return 29 * this.getOaiId().hashCode();
    }
}

