/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.queue;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.queue.LiveQueuePriority;
import org.slf4j.Logger;

public class LiveQueue {
    private static Logger logger;
    private static PriorityBlockingQueue<LiveQueueItem> queue;
    private static HashMap<Long, Integer> uniqueMap;
    private static HashMap<LiveQueuePriority, Long> counts;
    private static HashMap<LiveQueuePriority, String> modificationDate;

    private LiveQueue() {
    }

    public static void add(LiveQueueItem item) {
        Integer value = LiveQueue.getUniqueMap().get(item.getItemID());
        int finalValue = 1;
        if (value != null) {
            Iterator<LiveQueueItem> iterator = LiveQueue.getQueue().iterator();
            while (iterator.hasNext()) {
                LiveQueueItem e = iterator.next();
                if (e.getItemID() != item.getItemID()) continue;
                LiveQueuePriority existingPriority = e.getPriority();
                LiveQueuePriority newPriority = item.getPriority();
                if (newPriority.compareTo(existingPriority) > 0) {
                    if (existingPriority.equals((Object)LiveQueuePriority.MappingPriority)) {
                        ++finalValue;
                        continue;
                    }
                    iterator.remove();
                    LiveQueue.getCounts().put(item.getPriority(), LiveQueue.getPrioritySize(e.getPriority()) - 1L);
                    continue;
                }
                return;
            }
        }
        LiveQueue.getUniqueMap().put(item.getItemID(), finalValue);
        LiveQueue.getCounts().put(item.getPriority(), LiveQueue.getPrioritySize(item.getPriority()) + 1L);
        LiveQueue.getQueue().add(item);
    }

    public static LiveQueueItem take() throws InterruptedException {
        LiveQueueItem item = LiveQueue.getQueue().take();
        int value = LiveQueue.getUniqueMap().remove(item.getItemID());
        if (value != 1) {
            LiveQueue.getUniqueMap().put(item.getItemID(), value - 1);
        }
        LiveQueue.getCounts().put(item.getPriority(), LiveQueue.getPrioritySize(item.getPriority()) - 1L);
        LiveQueue.getModDates().put(item.getPriority(), item.getModificationDate());
        return item;
    }

    public static long getQueueSize() {
        return LiveQueue.getQueue().size();
    }

    public static long getPrioritySize(LiveQueuePriority priority) {
        Long value = LiveQueue.getCounts().get((Object)priority);
        return value == null ? 0L : value;
    }

    public static String getPriorityDate(LiveQueuePriority priority) {
        for (LiveQueueItem i : queue) {
            if (i.getPriority() != priority) continue;
            return i.getModificationDate();
        }
        String d = LiveQueue.getModDates().get((Object)priority);
        if (d != null) {
            return d;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PriorityBlockingQueue<LiveQueueItem> getQueue() {
        if (queue != null) return queue;
        Class<LiveQueue> clazz = LiveQueue.class;
        synchronized (LiveQueue.class) {
            if (queue != null) return queue;
            queue = new PriorityBlockingQueue(1000);
            // ** MonitorExit[var0] (shouldn't be in output)
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Long, Integer> getUniqueMap() {
        if (uniqueMap != null) return uniqueMap;
        Class<LiveQueue> clazz = LiveQueue.class;
        synchronized (LiveQueue.class) {
            if (uniqueMap != null) return uniqueMap;
            uniqueMap = new HashMap(1000);
            // ** MonitorExit[var0] (shouldn't be in output)
            return uniqueMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<LiveQueuePriority, Long> getCounts() {
        if (counts != null) return counts;
        Class<LiveQueue> clazz = LiveQueue.class;
        synchronized (LiveQueue.class) {
            if (counts != null) return counts;
            counts = new HashMap(10);
            // ** MonitorExit[var0] (shouldn't be in output)
            return counts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<LiveQueuePriority, String> getModDates() {
        if (modificationDate != null) return modificationDate;
        Class<LiveQueue> clazz = LiveQueue.class;
        synchronized (LiveQueue.class) {
            if (modificationDate != null) return modificationDate;
            modificationDate = new HashMap(5);
            // ** MonitorExit[var0] (shouldn't be in output)
            return modificationDate;
        }
    }

    static {
        queue = null;
        uniqueMap = null;
        counts = null;
        modificationDate = null;
    }
}

