/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.publisher;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.dbpedia.extraction.live.core.LiveOptions;
import org.dbpedia.extraction.live.util.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherService {
    private static final Logger logger = LoggerFactory.getLogger(PublisherService.class);
    private static long sequence = -2L;
    private static int year = -2;
    private static int month = -2;
    private static int day = -2;
    private static int hour = -2;

    protected PublisherService() {
    }

    public static synchronized String getNextPublishPath() {
        Calendar curDate;
        if (sequence == -2L) {
            PublisherService.init();
        }
        if ((curDate = Calendar.getInstance()).get(11) == hour && curDate.get(5) == day && curDate.get(2) + 1 == month && curDate.get(1) == year) {
            ++sequence;
        } else {
            sequence = 0L;
            hour = curDate.get(11);
            day = curDate.get(5);
            month = curDate.get(2) + 1;
            year = curDate.get(1);
        }
        PublisherService.writeLastPublishPath();
        return PublisherService.getCurrentPublishPath();
    }

    public static void writeLastPublishPath() {
        if (year < 0 && month < 0 && day < 0 && hour < 0 && sequence < 0L) {
            return;
        }
        File f = new File((String)LiveOptions.options.get((Object)"publishDiffRepoPath") + "/lastPublishedFile.txt");
        Files.createFile(f, PublisherService.getCurrentPublishPath().replace('/', '-'));
    }

    private static String readLastPublishPath() {
        File f = new File((String)LiveOptions.options.get((Object)"publishDiffRepoPath") + "/lastPublishedFile.txt");
        try {
            return Files.readFile(f);
        }
        catch (IOException exp) {
            logger.warn("Last publish date cannot be read due to " + exp.getMessage());
            logger.info("Assuming the last publish date is now");
            return "";
        }
    }

    private static String getCurrentPublishPath() {
        return String.format("%04d/%02d/%02d/%02d/%06d", year, month, day, hour, sequence);
    }

    private static void init() {
        String lastPath = PublisherService.readLastPublishPath();
        if (lastPath.isEmpty()) {
            Calendar curDate = Calendar.getInstance();
            sequence = -1L;
            hour = curDate.get(11);
            day = curDate.get(5);
            month = curDate.get(2) + 1;
            year = curDate.get(1);
        } else {
            String[] parts = lastPath.split("-");
            year = Integer.parseInt(parts[0].trim());
            month = Integer.parseInt(parts[1].trim());
            day = Integer.parseInt(parts[2].trim());
            hour = Integer.parseInt(parts[3].trim());
            sequence = Long.parseLong(parts[4].trim());
        }
    }
}

