/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.publisher;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.live.core.LiveOptions;
import org.dbpedia.extraction.live.main.Main;
import org.dbpedia.extraction.live.publisher.DiffData;
import org.dbpedia.extraction.live.publisher.PublisherService;
import org.dbpedia.extraction.live.publisher.RDFDiffWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Publisher
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(Publisher.class);
    private static final int MAX_QUEUE_SIZE = 5000;
    private static final int MAX_CHANGE_SETS = 400;
    private volatile HashSet<Quad> addedTriples = new HashSet();
    private volatile HashSet<Quad> deletedTriples = new HashSet();
    private volatile HashSet<Quad> reInsertedTriples = new HashSet();
    private volatile HashSet<Quad> subjectsClear = new HashSet();
    private volatile HashSet<Long> pageCache = new HashSet();
    private final String publishDiffBaseName = (String)LiveOptions.options.get((Object)"publishDiffRepoPath");

    public Publisher(String name, int priority) {
        this.setPriority(priority);
        this.setName(name);
        this.start();
    }

    public Publisher(String name) {
        this(name, 5);
    }

    public Publisher() {
        this("Publisher", 5);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    DiffData pubData = Main.publishingDataQueue.take();
                    if (this.pageCache.contains(pubData.pageID) || this.pageCache.size() > 400 || this.addedTriples.size() > 5000 || this.deletedTriples.size() > 5000 || this.reInsertedTriples.size() > 5000) {
                        this.pageCache.clear();
                        this.flush();
                    }
                    this.bufferDiff(pubData);
                    this.pageCache.add(pubData.pageID);
                }
            }
            catch (Throwable t) {
                logger.error("An exception was encountered in the Publisher update loop", t);
                continue;
            }
            break;
        }
    }

    private void bufferDiff(DiffData pubData) {
        if (pubData != null) {
            this.addedTriples.addAll(pubData.toAdd);
            this.deletedTriples.addAll(pubData.toDelete);
            this.reInsertedTriples.addAll(pubData.toReInsert);
            this.subjectsClear.addAll(pubData.subjects);
        }
    }

    public void flush() throws IOException {
        if (this.addedTriples.isEmpty() && this.deletedTriples.isEmpty() && this.reInsertedTriples.isEmpty() && this.subjectsClear.isEmpty()) {
            return;
        }
        String fileName = this.publishDiffBaseName + "/" + PublisherService.getNextPublishPath();
        File parent = new File(fileName).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (!this.addedTriples.isEmpty()) {
            RDFDiffWriter.writeAsTurtle(this.addedTriples, fileName + ".added.nt.gz");
            this.addedTriples.clear();
        }
        if (!this.deletedTriples.isEmpty()) {
            RDFDiffWriter.writeAsTurtle(this.deletedTriples, fileName + ".removed.nt.gz");
            this.deletedTriples.clear();
        }
        if (!this.reInsertedTriples.isEmpty()) {
            RDFDiffWriter.writeAsTurtle(this.reInsertedTriples, fileName + ".reinserted.nt.gz");
            this.reInsertedTriples.clear();
        }
        if (!this.subjectsClear.isEmpty()) {
            RDFDiffWriter.writeAsTurtle(this.subjectsClear, fileName + ".clear.nt.gz");
            this.subjectsClear.clear();
        }
    }
}

