/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.main;

import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.dbpedia.extraction.live.core.LiveOptions;
import org.dbpedia.extraction.live.feeder.Feeder;
import org.dbpedia.extraction.live.feeder.OAIFeeder;
import org.dbpedia.extraction.live.feeder.OAIFeederMappings;
import org.dbpedia.extraction.live.feeder.UnmodifiedFeeder;
import org.dbpedia.extraction.live.processor.PageProcessor;
import org.dbpedia.extraction.live.publisher.DiffData;
import org.dbpedia.extraction.live.publisher.Publisher;
import org.dbpedia.extraction.live.queue.LiveQueue;
import org.dbpedia.extraction.live.queue.LiveQueuePriority;
import org.dbpedia.extraction.live.storage.JDBCUtil;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.dbpedia.extraction.live.util.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    public static BlockingQueue<DiffData> publishingDataQueue = new LinkedBlockingDeque<DiffData>(1000);
    private static volatile List<Feeder> feeders = new ArrayList<Feeder>(5);
    private static volatile List<PageProcessor> processors = new ArrayList<PageProcessor>(10);
    private static volatile Publisher publisher;

    public static void authenticate(final String username, final String password) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password.toCharArray());
            }
        });
    }

    public static void initLive() {
        long sleepInterval;
        long pollInterval;
        JDBCUtil.execSQL("SET names utf8");
        if (Boolean.parseBoolean((String)LiveOptions.options.get((Object)"feeder.mappings.enabled"))) {
            pollInterval = Long.parseLong((String)LiveOptions.options.get((Object)"feeder.mappings.pollInterval"));
            sleepInterval = Long.parseLong((String)LiveOptions.options.get((Object)"feeder.mappings.sleepInterval"));
            feeders.add(new OAIFeederMappings("FeederMappings", LiveQueuePriority.MappingPriority, (String)LiveOptions.options.get((Object)"mappingsOAIUri"), (String)LiveOptions.options.get((Object)"mappingsBaseWikiUri"), (String)LiveOptions.options.get((Object)"mappingsOaiPrefix"), pollInterval, sleepInterval, (String)LiveOptions.options.get((Object)"uploaded_dump_date"), (String)LiveOptions.options.get((Object)"working_directory")));
        }
        if (Boolean.parseBoolean((String)LiveOptions.options.get((Object)"feeder.live.enabled"))) {
            pollInterval = Long.parseLong((String)LiveOptions.options.get((Object)"feeder.live.pollInterval"));
            sleepInterval = Long.parseLong((String)LiveOptions.options.get((Object)"feeder.live.sleepInterval"));
            feeders.add(new OAIFeeder("FeederLive", LiveQueuePriority.LivePriority, (String)LiveOptions.options.get((Object)"oaiUri"), (String)LiveOptions.options.get((Object)"baseWikiUri"), (String)LiveOptions.options.get((Object)"oaiPrefix"), pollInterval, sleepInterval, (String)LiveOptions.options.get((Object)"uploaded_dump_date"), (String)LiveOptions.options.get((Object)"working_directory")));
        }
        if (Boolean.parseBoolean((String)LiveOptions.options.get((Object)"feeder.unmodified.enabled"))) {
            int minDaysAgo = Integer.parseInt((String)LiveOptions.options.get((Object)"feeder.unmodified.minDaysAgo"));
            int chunk = Integer.parseInt((String)LiveOptions.options.get((Object)"feeder.unmodified.chunk"));
            int threshold = Integer.parseInt((String)LiveOptions.options.get((Object)"feeder.unmodified.threshold"));
            long sleepTime = Long.parseLong((String)LiveOptions.options.get((Object)"feeder.unmodified.sleepTime"));
            feeders.add(new UnmodifiedFeeder("FeederUnmodified", LiveQueuePriority.UnmodifiedPagePriority, minDaysAgo, chunk, threshold, sleepTime, (String)LiveOptions.options.get((Object)"uploaded_dump_date"), (String)LiveOptions.options.get((Object)"working_directory")));
        }
        int threads = Integer.parseInt((String)LiveOptions.options.get((Object)"ProcessingThreads"));
        for (int i = 0; i < threads; ++i) {
            processors.add(new PageProcessor("N" + (i + 1)));
        }
    }

    public static void startLive() {
        try {
            for (Feeder f : feeders) {
                f.startFeeder();
            }
            for (PageProcessor p : processors) {
                p.startProcessor();
            }
            publisher = new Publisher("Publisher", 4);
            logger.info("DBpedia-Live components started");
        }
        catch (Exception exp) {
            logger.error(ExceptionUtil.toString(exp), (Throwable)exp);
            Main.stopLive();
        }
    }

    public static void stopLive() {
        try {
            logger.warn("Stopping DBpedia Live components");
            for (PageProcessor p : processors) {
                p.stopProcessor();
            }
            for (Feeder f : feeders) {
                f.stopFeeder(LiveQueue.getPriorityDate(f.getQueuePriority()));
            }
            publisher.flush();
        }
        catch (Exception exp) {
            logger.error(ExceptionUtil.toString(exp));
        }
    }

    public static void main(String[] args) throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Main.stopLive();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Main.authenticate("dbpedia", Files.readFile(new File("pw.txt")).trim());
        Main.initLive();
        Main.startLive();
    }
}

