/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dbpedia.extraction.live.core.Constants;
import org.dbpedia.extraction.live.helper.ExtractorSpecification;
import org.dbpedia.extraction.live.helper.ExtractorStatus;
import org.dbpedia.extraction.live.helper.MatchPattern;
import org.dbpedia.extraction.live.helper.MatchType;
import org.dbpedia.extraction.mappings.ArticleCategoriesExtractor;
import org.dbpedia.extraction.mappings.SkosCategoriesExtractor;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.impl.wikipedia.Namespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LiveConfigReader {
    private static Logger logger = LoggerFactory.getLogger(LiveConfigReader.class);
    private static final String liveConfigFile = "./live.xml";
    private static DocumentBuilderFactory dbFactory;
    private static DocumentBuilder dBuilder;
    private static Document doc;
    private static final String EXTRACTOR_TAGNAME = "extractor";
    private static final String LANUAGE_TAGNAME = "language";
    private static final String UPDATE_ONTOLGY_AND_MAPPINGS_PERIOD_TAGNAME = "updateOntologyAndMappingsPeriod";
    private static final String NAME_ATTRIBUTENAME = "name";
    private static final String EXTRACTOR_STATUS_ATTRIBUTENAME = "status";
    private static final String MATCH_PATTERN_TAGNAME = "matchPattern";
    private static final String MATCH_PATTERN_TYPE_ATTRIBUTENAME = "type";
    private static final String PEXACT_ATTRIBUTENAME = "pexact";
    private static final String SUBJECT_TAGNAME = "s";
    private static final String PREDICATE_TAGNAME = "p";
    private static final String OBJECT_TAGNAME = "o";
    private static final String NOTICE_TAGNAME = "notice";
    public static Map<Language, Map<String, ExtractorSpecification>> extractors;
    public static Map<Language, List<Class>> extractorClasses;

    private static void readExtractors() {
        NodeList languageNodes = doc.getElementsByTagName(LANUAGE_TAGNAME);
        extractors = new HashMap<Language, Map<String, ExtractorSpecification>>();
        extractorClasses = new HashMap<Language, List<Class>>();
        for (int i = 0; i < languageNodes.getLength(); ++i) {
            Element elemLanguage = (Element)languageNodes.item(i);
            String languageName = elemLanguage.getAttribute(NAME_ATTRIBUTENAME);
            Language language = Language.apply((String)languageName);
            LiveConfigReader.readLanguageExtractors(elemLanguage, language);
        }
    }

    private static void readLanguageExtractors(Element elemLanguageExtractors, Language lang) {
        try {
            NodeList extractorNodes = elemLanguageExtractors.getElementsByTagName(EXTRACTOR_TAGNAME);
            HashMap<String, ExtractorSpecification> langExtractors = new HashMap<String, ExtractorSpecification>(20);
            ArrayList langExtractorClasses = new ArrayList(20);
            for (int i = 0; i < extractorNodes.getLength(); ++i) {
                MatchPattern extractorSpecificPattern = null;
                Element elemExtractor = (Element)extractorNodes.item(i);
                String extractorID = elemExtractor.getAttribute(NAME_ATTRIBUTENAME);
                ExtractorStatus status = ExtractorStatus.valueOf(elemExtractor.getAttribute(EXTRACTOR_STATUS_ATTRIBUTENAME));
                langExtractorClasses.add(ClassLoader.getSystemClassLoader().loadClass(extractorID));
                if (extractorID.equals(SkosCategoriesExtractor.class.toString()) || extractorID.equals(ArticleCategoriesExtractor.class.toString())) {
                    extractorSpecificPattern = LiveConfigReader._addGenerics(lang, extractorID);
                }
                ArrayList<MatchPattern> patternsList = LiveConfigReader._getExtractorMatchPatterns(elemExtractor);
                if (extractorSpecificPattern != null) {
                    patternsList.add(extractorSpecificPattern);
                }
                langExtractors.put(extractorID, new ExtractorSpecification(extractorID, status, patternsList, LiveConfigReader._getExtractorNotices(elemExtractor)));
                extractors.put(lang, langExtractors);
                extractorClasses.put(lang, langExtractorClasses);
            }
            System.out.println(extractors);
        }
        catch (Exception exp) {
            logger.error(exp.getMessage(), (Throwable)exp);
        }
    }

    private static MatchPattern _addGenerics(Language lang, String extractorID) {
        MatchPattern pattern = null;
        if (extractorID.equals(SkosCategoriesExtractor.class.toString())) {
            pattern = new MatchPattern(MatchType.STARTSWITH, "", "http://www.w3.org/2004/02/skos/core#broader", Namespaces.names((Language)lang).get((Object)Namespace.Category()).toString(), true);
        } else if (extractorID.equals(ArticleCategoriesExtractor.class.toString())) {
            pattern = new MatchPattern(MatchType.STARTSWITH, "", "http://www.w3.org/2004/02/skos/core#subject", Namespaces.names((Language)lang).get((Object)Namespace.Category()).toString(), true);
        }
        return pattern;
    }

    private static ArrayList<MatchPattern> _getExtractorMatchPatterns(Element extractorElem) {
        ArrayList<MatchPattern> patterns = new ArrayList<MatchPattern>();
        NodeList patternNodes = extractorElem.getElementsByTagName(MATCH_PATTERN_TAGNAME);
        try {
            for (int i = 0; i < patternNodes.getLength(); ++i) {
                Element elemPattern = (Element)patternNodes.item(i);
                MatchType type = MatchType.valueOf(elemPattern.getAttribute(MATCH_PATTERN_TYPE_ATTRIBUTENAME));
                boolean pexact = Boolean.parseBoolean(elemPattern.getAttribute(PEXACT_ATTRIBUTENAME));
                String subject = elemPattern.getElementsByTagName(SUBJECT_TAGNAME).item(0).getTextContent();
                try {
                    if (Constants.class.getField(subject).get(Constants.class) != null) {
                        subject = Constants.class.getField(subject).get(Constants.class).toString();
                    }
                }
                catch (Exception exp) {
                    // empty catch block
                }
                String predicate = elemPattern.getElementsByTagName(PREDICATE_TAGNAME).item(0).getTextContent();
                try {
                    if (Constants.class.getField(predicate).get(Constants.class) != null) {
                        predicate = Constants.class.getField(predicate).get(Constants.class).toString();
                    }
                }
                catch (Exception exp) {
                    // empty catch block
                }
                String object = elemPattern.getElementsByTagName(OBJECT_TAGNAME).item(0).getTextContent();
                try {
                    if (Constants.class.getField(object).get(Constants.class) != null) {
                        object = Constants.class.getField(object).get(Constants.class).toString();
                    }
                }
                catch (Exception exp) {
                    // empty catch block
                }
                patterns.add(new MatchPattern(type, subject, predicate, object, pexact));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return patterns.size() > 0 ? patterns : null;
    }

    private static ArrayList<String> _getExtractorNotices(Element extractorElem) {
        ArrayList<String> notices = new ArrayList<String>();
        NodeList extractorNotices = extractorElem.getElementsByTagName(NOTICE_TAGNAME);
        for (int i = 0; i < extractorNotices.getLength(); ++i) {
            Element noticeElem = (Element)extractorNotices.item(i);
            notices.add(noticeElem.getTextContent());
        }
        return notices.size() > 0 ? notices : null;
    }

    public static List<Class> getExtractors(Language lang, ExtractorStatus requiredStatus) {
        List<Class> extractorsList = extractorClasses.get(lang);
        Map<String, ExtractorSpecification> specs = extractors.get(lang);
        Iterator<ExtractorSpecification> i$ = specs.values().iterator();
        while (i$.hasNext()) {
            ExtractorSpecification value;
            ExtractorSpecification spec = value = i$.next();
            if (spec.status == requiredStatus) continue;
            try {
                extractorsList.remove(Class.forName(spec.extractorID));
            }
            catch (Exception exp) {}
        }
        return extractorsList;
    }

    static {
        extractors = null;
        extractorClasses = null;
        try {
            dbFactory = DocumentBuilderFactory.newInstance();
            dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(new File(liveConfigFile));
            LiveConfigReader.readExtractors();
        }
        catch (Exception exp) {
            logger.error(exp.getMessage(), (Throwable)exp);
        }
    }
}

