/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.helper;

import java.util.ArrayList;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.live.helper.ExtractorStatus;
import org.dbpedia.extraction.live.helper.MatchPattern;

public class ExtractorSpecification {
    public String extractorID;
    public ExtractorStatus status;
    public ArrayList<String> notices;
    public ArrayList<MatchPattern> generatedTriplePatterns;

    public ExtractorSpecification(String ID, ExtractorStatus extractorStatus, ArrayList<MatchPattern> patternsList, ArrayList<String> noticeList) {
        this.extractorID = ID;
        this.status = extractorStatus;
        this.generatedTriplePatterns = patternsList;
        this.notices = noticeList;
    }

    public ExtractorSpecification(String ID, ExtractorStatus extractorStatus, ArrayList<MatchPattern> patternsList) {
        this(ID, extractorStatus, patternsList, null);
    }

    public ExtractorSpecification(String ID, ExtractorStatus extractorStatus) {
        this(ID, extractorStatus, null, null);
    }

    public boolean accept(Quad quad) {
        if (this.status == ExtractorStatus.PURGE) {
            return false;
        }
        if (this.status == ExtractorStatus.KEEP) {
            return true;
        }
        if (this.generatedTriplePatterns != null) {
            for (MatchPattern rule : this.generatedTriplePatterns) {
                if (rule.accept(quad)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object passedExtractorSpec) {
        if (!(passedExtractorSpec instanceof ExtractorSpecification)) {
            return false;
        }
        ExtractorSpecification requiredExtractorSpec = (ExtractorSpecification)passedExtractorSpec;
        return this.extractorID.equals(requiredExtractorSpec.extractorID);
    }
}

