/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import org.dbpedia.extraction.live.core.LiveOptions;
import org.dbpedia.extraction.live.feeder.OAIFeeder;
import org.dbpedia.extraction.live.helper.MappingAffectedPagesHelper;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.queue.LiveQueuePriority;
import scala.collection.JavaConversions;

public class OAIFeederMappings
extends OAIFeeder {
    private String mappingNamespace = "";

    public OAIFeederMappings(String feederName, LiveQueuePriority queuePriority, String oaiUri, String oaiPrefix, String baseWikiUri, long pollInterval, long sleepInterval, String defaultStartTime, String folderBasePath) {
        super(feederName, queuePriority, oaiUri, oaiPrefix, baseWikiUri, pollInterval, sleepInterval, defaultStartTime, folderBasePath);
        String langCode = LiveOptions.language;
        this.mappingNamespace = "Mapping " + langCode + ":";
    }

    @Override
    protected void handleFeedItem(LiveQueueItem item) {
        if (!item.getItemName().startsWith(this.mappingNamespace)) {
            return;
        }
        String title = item.getItemName().substring(item.getItemName().indexOf(":") + 1);
        for (Object newItem : JavaConversions.asJavaIterable(MappingAffectedPagesHelper.GetMappingPages(title))) {
            this.addPageIDtoQueue(new LiveQueueItem((Long)newItem, item.getModificationDate()));
        }
    }
}

