/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dbpedia.extraction.live.feeder.Feeder;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.queue.LiveQueuePriority;
import org.dbpedia.extraction.live.util.OAIUtil;

public class OAIFeeder
extends Feeder {
    protected final String oaiUri;
    protected final String oaiPrefix;
    protected final String baseWikiUri;
    protected final long pollInterval;
    protected final long sleepInterval;
    protected Iterator<LiveQueueItem> oaiRecordIterator;

    public OAIFeeder(String feederName, LiveQueuePriority queuePriority, String oaiUri, String oaiPrefix, String baseWikiUri, long pollInterval, long sleepInterval, String defaultStartTime, String folderBasePath) {
        super(feederName, queuePriority, defaultStartTime, folderBasePath);
        this.oaiUri = oaiUri;
        this.oaiPrefix = oaiPrefix;
        this.baseWikiUri = baseWikiUri;
        this.pollInterval = pollInterval;
        this.sleepInterval = sleepInterval;
    }

    @Override
    protected void initFeeder() {
        this.oaiRecordIterator = OAIUtil.createEndlessFeederItemIterator(this.oaiUri, this.latestProcessDate, this.pollInterval, this.sleepInterval);
    }

    @Override
    protected List<LiveQueueItem> getNextItems() {
        ArrayList<LiveQueueItem> i = new ArrayList<LiveQueueItem>();
        i.add(this.oaiRecordIterator.next());
        return i;
    }
}

