/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import java.io.File;
import java.util.List;
import org.dbpedia.extraction.live.queue.LiveQueue;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.queue.LiveQueuePriority;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.dbpedia.extraction.live.util.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Feeder
extends Thread {
    protected static Logger logger;
    protected final String feederName;
    protected final LiveQueuePriority queuePriority;
    protected final String defaultStartTime;
    protected final File latestProcessDateFile;
    protected String latestProcessDate;
    private volatile boolean keepRunning = true;

    public Feeder(String feederName, LiveQueuePriority queuePriority, String defaultStartTime, String folderBasePath) {
        this.feederName = feederName;
        this.setName("Feeder_" + feederName);
        logger = LoggerFactory.getLogger((String)feederName);
        this.queuePriority = queuePriority;
        this.defaultStartTime = defaultStartTime;
        this.latestProcessDateFile = new File(folderBasePath + feederName + ".dat");
        this.getLatestProcessedDate();
    }

    public LiveQueuePriority getQueuePriority() {
        return this.queuePriority;
    }

    protected abstract void initFeeder();

    public void startFeeder() {
        if (this.keepRunning) {
            this.initFeeder();
            this.start();
        }
    }

    public void stopFeeder(String date) {
        this.keepRunning = false;
        this.setLatestProcessedDate(date);
    }

    public String getLatestProcessedDate() {
        this.latestProcessDate = this.defaultStartTime;
        try {
            if (!this.latestProcessDateFile.exists()) {
                this.setLatestProcessedDate(this.defaultStartTime);
            } else {
                this.latestProcessDate = Files.readFile(this.latestProcessDateFile).trim();
            }
        }
        catch (Exception exp) {
            logger.error(ExceptionUtil.toString(exp), (Throwable)exp);
        }
        if (this.latestProcessDate.isEmpty()) {
            this.latestProcessDate = this.defaultStartTime;
            this.setLatestProcessedDate(this.latestProcessDate);
        }
        logger.warn("Resuming from date: " + this.latestProcessDate);
        return this.latestProcessDate;
    }

    public synchronized void setLatestProcessedDate(String date) {
        if (date == null || date.equals("")) {
            date = this.latestProcessDate;
        }
        Files.createFile(this.latestProcessDateFile, date);
    }

    protected abstract List<LiveQueueItem> getNextItems();

    @Override
    public void run() {
        int counter = 0;
        while (this.keepRunning) {
            try {
                for (LiveQueueItem item : this.getNextItems()) {
                    this.handleFeedItem(item);
                }
            }
            catch (OutOfMemoryError exp) {
                logger.error(ExceptionUtil.toString(exp), (Throwable)exp);
                throw new RuntimeException("OutOfMemory Error", exp);
            }
            catch (Exception exp) {
                logger.error(ExceptionUtil.toString(exp), (Throwable)exp);
                this.initFeeder();
            }
            if (counter % 500 == 0) {
                this.setLatestProcessedDate(null);
                counter = 0;
            }
            ++counter;
        }
    }

    protected void handleFeedItem(LiveQueueItem item) {
        this.addPageIDtoQueue(item);
    }

    protected void addPageIDtoQueue(LiveQueueItem item) {
        item.setStatQueueAdd(-1L);
        item.setPriority(this.queuePriority);
        LiveQueue.add(item);
        this.latestProcessDate = item.getModificationDate();
    }
}

