/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.extraction;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import org.dbpedia.extraction.destinations.CompositeLiveDestination;
import org.dbpedia.extraction.destinations.ExtractorRestrictDestination;
import org.dbpedia.extraction.destinations.JSONCacheExtractorDestination;
import org.dbpedia.extraction.destinations.JSONCacheUpdateDestination;
import org.dbpedia.extraction.destinations.LiveDestination;
import org.dbpedia.extraction.destinations.LoggerDestination;
import org.dbpedia.extraction.destinations.PublisherDiffDestination;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.destinations.formatters.UriPolicy$;
import org.dbpedia.extraction.live.core.LiveOptions;
import org.dbpedia.extraction.live.extraction.LiveExtractionConfigLoader$;
import org.dbpedia.extraction.live.extractor.LiveExtractor$;
import org.dbpedia.extraction.live.helper.ExtractorStatus;
import org.dbpedia.extraction.live.helper.LiveConfigReader;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.storage.JSONCache;
import org.dbpedia.extraction.live.storage.JSONCache$;
import org.dbpedia.extraction.mappings.Extractor;
import org.dbpedia.extraction.mappings.JsonNodeExtractor;
import org.dbpedia.extraction.mappings.PageContext;
import org.dbpedia.extraction.mappings.PageNodeExtractor;
import org.dbpedia.extraction.mappings.WikiPageExtractor;
import org.dbpedia.extraction.sources.Source;
import org.dbpedia.extraction.sources.WikiPage;
import org.dbpedia.extraction.sources.WikiSource$;
import org.dbpedia.extraction.sources.XMLSource$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.wikiparser.JsonNode;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.Namespace$;
import org.dbpedia.extraction.wikiparser.PageNode;
import org.dbpedia.extraction.wikiparser.WikiParser;
import org.dbpedia.extraction.wikiparser.WikiParser$;
import org.dbpedia.extraction.wikiparser.impl.json.JsonWikiParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.xml.Elem;
import scala.xml.XML$;

public final class LiveExtractionConfigLoader$ {
    public static final LiveExtractionConfigLoader$ MODULE$;
    private List<Extractor<?>> org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors;
    private boolean reloadOntologyAndMapping;
    private long ontologyAndMappingsUpdateTime;
    private final Logger logger;
    private final Source ontologySource;
    private final Source mappingsSource;
    private final Null$ commonsSource;
    private final Function1<URI, URI>[] policies;

    static {
        new LiveExtractionConfigLoader$();
    }

    public List<Extractor<?>> org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors() {
        return this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors;
    }

    private void org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors_$eq(List<Extractor<?>> x$1) {
        this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors = x$1;
    }

    private boolean reloadOntologyAndMapping() {
        return this.reloadOntologyAndMapping;
    }

    private void reloadOntologyAndMapping_$eq(boolean x$1) {
        this.reloadOntologyAndMapping = x$1;
    }

    private long ontologyAndMappingsUpdateTime() {
        return this.ontologyAndMappingsUpdateTime;
    }

    private void ontologyAndMappingsUpdateTime_$eq(long x$1) {
        this.ontologyAndMappingsUpdateTime = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public Source ontologySource() {
        return this.ontologySource;
    }

    public Source mappingsSource() {
        return this.mappingsSource;
    }

    public Null$ commonsSource() {
        return null;
    }

    public Function1<URI, URI>[] policies() {
        return this.policies;
    }

    public void reload(long t) {
        if (t > this.ontologyAndMappingsUpdateTime()) {
            this.reloadOntologyAndMapping_$eq(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private File getDumpFile(File dumpDir, String wikiPrefix) {
        void var3_3;
        File wikiDir = new File(new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)dumpDir), "/")).append((Object)wikiPrefix).toString());
        if (wikiDir.isDirectory()) {
            void var5_5;
            String date = (String)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])wikiDir.list()).filter((Function1)new Serializable(){

                public final boolean apply(String x$1) {
                    return x$1.matches("\\d{8}");
                }
            })).sortWith((Function2)new Serializable(){

                public final boolean apply(String x$2, String x$3) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt() > new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
                }
            })).headOption().getOrElse((Function0)new Serializable(wikiPrefix){
                private final String wikiPrefix$1;

                public final Nothing$ apply() {
                    throw new Exception(new StringBuilder().append((Object)"No dump found for Wiki: ").append((Object)this.wikiPrefix$1).toString());
                }
                {
                    this.wikiPrefix$1 = wikiPrefix$1;
                }
            });
            File articlesDump = new File(new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)wikiDir), "/")).append((Object)date).append((Object)"/").append((Object)wikiPrefix.replace('-', '_')).append((Object)"wiki-").append((Object)date).append((Object)"-pages-articles.xml").toString());
            if (articlesDump.isFile()) {
                return articlesDump;
            }
            throw new Exception(new StringBuilder().append((Object)"Dump not found: ").append((Object)var5_5).toString());
        }
        throw new Exception(new StringBuilder().append((Object)"Dump directory not found: ").append((Object)var3_3).toString());
    }

    public boolean extractPage(LiveQueueItem item, String apiURL, String landCode) {
        Language lang = Language$.MODULE$.apply(landCode);
        Source articlesSource = item.getXML().isEmpty() ? WikiSource$.MODULE$.fromPageIDs((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{item.getItemID()})), new URL(apiURL), lang) : XMLSource$.MODULE$.fromOAIXML((Elem)XML$.MODULE$.loadString(item.getXML()));
        return this.startExtraction(articlesSource, lang);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startExtraction(Source articlesSource, Language language) {
        BoxedUnit boxedUnit;
        if (this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors() == null || this.reloadOntologyAndMapping()) {
            LiveExtractionConfigLoader$ liveExtractionConfigLoader$ = this;
            synchronized (liveExtractionConfigLoader$) {
                BoxedUnit boxedUnit2;
                if (this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors() == null || this.reloadOntologyAndMapping()) {
                    this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors_$eq(this.LoadOntologyAndMappings(articlesSource, language));
                    this.logger().info("Ontology and mappings reloaded");
                    this.reloadOntologyAndMapping_$eq(false);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl13 : MonitorExitStatement: MONITOREXIT : liveExtractionConfigLoader$
                boxedUnit = boxedUnit3;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BooleanRef complete = BooleanRef.create((boolean)false);
        articlesSource.foreach((Function1)new Serializable(language, complete){
            private final Language language$1;
            private final BooleanRef complete$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(WikiPage wikiPage) {
                block3: {
                    VolatileByteRef bitmap$0;
                    block2: {
                        bitmap$0 = VolatileByteRef.create((byte)0);
                        Namespace namespace = wikiPage.title().namespace();
                        Namespace namespace2 = Namespace$.MODULE$.Main();
                        if (!(namespace == null ? namespace2 != null : !namespace.equals(namespace2))) break block2;
                        Namespace namespace3 = wikiPage.title().namespace();
                        Namespace namespace4 = Namespace$.MODULE$.Template();
                        if (!(namespace3 == null ? namespace4 != null : !namespace3.equals(namespace4))) break block2;
                        Namespace namespace5 = wikiPage.title().namespace();
                        Namespace namespace6 = Namespace$.MODULE$.Category();
                        if (namespace5 != null ? !namespace5.equals(namespace6) : namespace6 != null) break block3;
                    }
                    ObjectRef pageNode$lzy = ObjectRef.zero();
                    ObjectRef jsonNode$lzy = ObjectRef.zero();
                    JSONCache liveCache = new JSONCache(wikiPage.id(), wikiPage.title().decoded());
                    ArrayBuffer destList = new ArrayBuffer();
                    destList.$plus$eq((Object)new JSONCacheUpdateDestination(liveCache));
                    destList.$plus$eq((Object)new PublisherDiffDestination(wikiPage.id(), liveCache.performCleanUpdate(), liveCache.cacheObj() == null ? new HashSet<E>() : liveCache.cacheObj().subjects()));
                    destList.$plus$eq((Object)new LoggerDestination(wikiPage.id(), wikiPage.title().decoded()));
                    CompositeLiveDestination compositeDest = new CompositeLiveDestination((Seq<LiveDestination>)destList.toSeq());
                    JSONCacheExtractorDestination extractorDiffDest = new JSONCacheExtractorDestination(liveCache, compositeDest);
                    ExtractorRestrictDestination extractorRestrictDest = new ExtractorRestrictDestination(LiveConfigReader.extractors.get(Language$.MODULE$.apply(this.language$1.isoCode())), extractorDiffDest);
                    String uri = wikiPage.title().language().resourceUri().append(wikiPage.title().decodedWithNamespace());
                    PageContext context = new PageContext();
                    extractorRestrictDest.open();
                    LiveExtractionConfigLoader$.MODULE$.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors().foreach((Function1)new Serializable(this, extractorRestrictDest, pageNode$lzy, jsonNode$lzy, uri, context, wikiPage, bitmap$0){
                        private final /* synthetic */ anonfun.startExtraction.1 $outer;
                        private final ExtractorRestrictDestination extractorRestrictDest$1;
                        private final ObjectRef pageNode$lzy$1;
                        private final ObjectRef jsonNode$lzy$1;
                        private final String uri$1;
                        private final PageContext context$1;
                        private final WikiPage wikiPage$1;
                        private final VolatileByteRef bitmap$0$1;

                        public final void apply(Extractor<?> extractor) {
                            Seq seq;
                            try {
                                Seq seq2;
                                Extractor<?> extractor2 = extractor;
                                if (extractor2 instanceof PageNodeExtractor) {
                                    Seq seq3;
                                    PageNodeExtractor pageNodeExtractor = (PageNodeExtractor)extractor2;
                                    Option option = this.$outer.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$anonfun$$pageNode$1(this.pageNode$lzy$1, this.wikiPage$1, this.bitmap$0$1);
                                    if (option instanceof Some) {
                                        Some some = (Some)option;
                                        PageNode pageNodeValue = (PageNode)some.x();
                                        seq3 = pageNodeExtractor.extract((Object)pageNodeValue, this.uri$1, this.context$1);
                                    } else {
                                        seq3 = (Seq)Seq$.MODULE$.empty();
                                    }
                                    seq2 = seq3;
                                } else if (extractor2 instanceof JsonNodeExtractor) {
                                    Seq seq4;
                                    JsonNodeExtractor jsonNodeExtractor = (JsonNodeExtractor)extractor2;
                                    Option option = this.$outer.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$anonfun$$jsonNode$1(this.jsonNode$lzy$1, this.wikiPage$1, this.bitmap$0$1);
                                    if (option instanceof Some) {
                                        Some some = (Some)option;
                                        JsonNode jsonNodeValue = (JsonNode)some.x();
                                        seq4 = jsonNodeExtractor.extract((Object)jsonNodeValue, this.uri$1, this.context$1);
                                    } else {
                                        seq4 = (Seq)Seq$.MODULE$.empty();
                                    }
                                    seq2 = seq4;
                                } else if (extractor2 instanceof WikiPageExtractor) {
                                    WikiPageExtractor wikiPageExtractor = (WikiPageExtractor)extractor2;
                                    seq2 = wikiPageExtractor.extract((Object)this.wikiPage$1, this.uri$1, this.context$1);
                                } else {
                                    seq2 = (Seq)Seq$.MODULE$.empty();
                                }
                                seq = seq2;
                            }
                            catch (Exception exception) {
                                LiveExtractionConfigLoader$.MODULE$.logger().error(new StringBuilder().append((Object)"Error in ").append((Object)extractor.getClass().getName()).append((Object)"\nError Message: ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
                                seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }
                            Seq RequiredGraph = seq;
                            this.extractorRestrictDest$1.write(extractor.getClass().getName(), "", (Seq<Quad>)RequiredGraph, (Seq<Quad>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Seq<Quad>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.extractorRestrictDest$1 = extractorRestrictDest$1;
                            this.pageNode$lzy$1 = pageNode$lzy$1;
                            this.jsonNode$lzy$1 = jsonNode$lzy$1;
                            this.uri$1 = uri$1;
                            this.context$1 = context$1;
                            this.wikiPage$1 = wikiPage$1;
                            this.bitmap$0$1 = bitmap$0$1;
                        }
                    });
                    extractorRestrictDest.close();
                    this.complete$1.elem = true;
                    return;
                }
                JSONCache$.MODULE$.deleteCacheOnlyItem(wikiPage.id());
            }

            private final Option pageNode$lzycompute$1(ObjectRef pageNode$lzy$1, WikiPage wikiPage$1, VolatileByteRef bitmap$0$1) {
                anonfun.startExtraction.1 var4_4 = this;
                synchronized (var4_4) {
                    if ((byte)(bitmap$0$1.elem & 1) == 0) {
                        WikiParser pageNodeParser = WikiParser$.MODULE$.getInstance(WikiParser$.MODULE$.getInstance$default$1());
                        pageNode$lzy$1.elem = pageNodeParser.apply(wikiPage$1);
                        bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
                    }
                    return (Option)pageNode$lzy$1.elem;
                }
            }

            public final Option org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$anonfun$$pageNode$1(ObjectRef pageNode$lzy$1, WikiPage wikiPage$1, VolatileByteRef bitmap$0$1) {
                return (byte)(bitmap$0$1.elem & 1) == 0 ? this.pageNode$lzycompute$1(pageNode$lzy$1, wikiPage$1, bitmap$0$1) : (Option)pageNode$lzy$1.elem;
            }

            private final Option jsonNode$lzycompute$1(ObjectRef jsonNode$lzy$1, WikiPage wikiPage$1, VolatileByteRef bitmap$0$1) {
                anonfun.startExtraction.1 var4_4 = this;
                synchronized (var4_4) {
                    if ((byte)(bitmap$0$1.elem & 2) == 0) {
                        JsonWikiParser jsonNodeParser = new JsonWikiParser();
                        jsonNode$lzy$1.elem = jsonNodeParser.apply(wikiPage$1);
                        bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
                    }
                    return (Option)jsonNode$lzy$1.elem;
                }
            }

            public final Option org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$anonfun$$jsonNode$1(ObjectRef jsonNode$lzy$1, WikiPage wikiPage$1, VolatileByteRef bitmap$0$1) {
                return (byte)(bitmap$0$1.elem & 2) == 0 ? this.jsonNode$lzycompute$1(jsonNode$lzy$1, wikiPage$1, bitmap$0$1) : (Option)jsonNode$lzy$1.elem;
            }
            {
                this.language$1 = language$1;
                this.complete$1 = complete$1;
            }
        });
        return complete.elem;
    }

    private List<Extractor<?>> LoadOntologyAndMappings(Source articlesSource, Language language) {
        this.ontologyAndMappingsUpdateTime_$eq(System.currentTimeMillis());
        List<Class<Extractor<?>>> extractorClasses = this.convertExtractorListToScalaList(LiveConfigReader.getExtractors(language, ExtractorStatus.ACTIVE));
        Source source = this.ontologySource();
        Source source2 = this.mappingsSource();
        this.commonsSource();
        return LiveExtractor$.MODULE$.load(source, source2, articlesSource, null, extractorClasses, language);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Class<Extractor<?>>> convertExtractorListToScalaList(java.util.List<Class<?>> list) {
        extractorList = Nil$.MODULE$;
        listiterator = list.iterator();
        while (true) {
            if (listiterator.hasNext()) ** GOTO lbl-1000
            return var2_2;
lbl-1000:
            // 1 sources

            {
                var5_5 = extractorList;
                extractorList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{listiterator.next()})).$colon$colon$colon((List)var5_5);
                continue;
            }
            break;
        }
    }

    private LiveExtractionConfigLoader$() {
        MODULE$ = this;
        this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors = null;
        this.reloadOntologyAndMapping = true;
        this.ontologyAndMappingsUpdateTime = 0L;
        this.logger = LoggerFactory.getLogger((String)"LiveExtractionConfigLoader");
        this.ontologySource = WikiSource$.MODULE$.fromNamespaces((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{Namespace$.MODULE$.OntologyClass(), Namespace$.MODULE$.OntologyProperty()})), new URL(Language$.MODULE$.Mappings().apiUri()), Language$.MODULE$.Mappings());
        this.mappingsSource = WikiSource$.MODULE$.fromNamespaces((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{(Namespace)Namespace$.MODULE$.mappings().apply((Object)Language$.MODULE$.apply(LiveOptions.language))})), new URL(Language$.MODULE$.Mappings().apiUri()), Language$.MODULE$.Mappings());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"COMMONS SOURCE = ").append(LiveOptions.options.get((Object)"commonsDumpsPath")).toString());
        this.commonsSource = null;
        this.policies = UriPolicy$.MODULE$.parsePolicy((String)LiveOptions.options.get((Object)"uri-policy.main"));
    }
}

