/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.export;

import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dbpedia.extraction.destinations.Destination;
import org.dbpedia.extraction.destinations.WriterDestination;
import org.dbpedia.extraction.destinations.formatters.Formatter;
import org.dbpedia.extraction.destinations.formatters.TerseFormatter;
import org.dbpedia.extraction.destinations.formatters.UriPolicy$;
import org.dbpedia.extraction.live.core.LiveOptions;
import org.dbpedia.extraction.live.export.DumpExport$;
import org.dbpedia.extraction.live.export.QuadProcessWorker;
import org.dbpedia.extraction.live.storage.DBpediaSQLQueries$;
import org.dbpedia.extraction.live.storage.JDBCPoolConnection;
import org.dbpedia.extraction.live.storage.JDBCUtil;
import org.dbpedia.extraction.util.FileLike;
import org.dbpedia.extraction.util.IOUtils$;
import org.dbpedia.extraction.util.RichFile$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u00015\u0011!\u0002R;na\u0016C\bo\u001c:u\u0015\t\u0019A!\u0001\u0004fqB|'\u000f\u001e\u0006\u0003\u000b\u0019\tA\u0001\\5wK*\u0011q\u0001C\u0001\u000bKb$(/Y2uS>t'BA\u0005\u000b\u0003\u001d!'\r]3eS\u0006T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\u0019LG.\u001a8b[\u0016,\u0012a\u0006\t\u00031mq!aD\r\n\u0005i\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0002\u001d;\t11\u000b\u001e:j]\u001eT!A\u0007\t\t\u0011}\u0001!\u0011!Q\u0001\n]\t\u0011BZ5mK:\fW.\u001a\u0011\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\nq\u0001\u001e5sK\u0006$7/F\u0001$!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0003mC:<'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012q!\u00138uK\u001e,'\u000f\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003$\u0003!!\bN]3bIN\u0004\u0003\"\u0002\u0018\u0001\t\u0003y\u0013A\u0002\u001fj]&$h\bF\u00021eM\u0002\"!\r\u0001\u000e\u0003\tAQ!F\u0017A\u0002]AQ!I\u0017A\u0002\rBq!\u000e\u0001C\u0002\u0013\u0005a'\u0001\u0004m_\u001e<WM]\u000b\u0002oA\u0011\u0001hO\u0007\u0002s)\u0011!HC\u0001\u0006g24GG[\u0005\u0003ye\u0012a\u0001T8hO\u0016\u0014\bB\u0002 \u0001A\u0003%q'A\u0004m_\u001e<WM\u001d\u0011\t\u000f\u0001\u0003!\u0019!C\u0001\u0003\u0006A\u0001o\u001c7jG&,7/F\u0001C!\ry1)R\u0005\u0003\tB\u0011Q!\u0011:sCf\u0004\"A\u0012(\u000f\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015A\u00034pe6\fG\u000f^3sg*\u00111JB\u0001\rI\u0016\u001cH/\u001b8bi&|gn]\u0005\u0003\u001b\"\u000b\u0011\"\u0016:j!>d\u0017nY=\n\u0005=\u0003&A\u0002)pY&\u001c\u0017P\u0003\u0002N\u0011\"1!\u000b\u0001Q\u0001\n\t\u000b\u0011\u0002]8mS\u000eLWm\u001d\u0011\t\u000fQ\u0003!\u0019!C\u0001+\u0006YA-Z:uS:\fG/[8o+\u00051\u0006CA,Y\u001b\u0005Q\u0015BA-K\u0005-!Um\u001d;j]\u0006$\u0018n\u001c8\t\rm\u0003\u0001\u0015!\u0003W\u00031!Wm\u001d;j]\u0006$\u0018n\u001c8!\u0011\u001di\u0006A1A\u0005\u0002y\u000b1\u0003\\5oW\u0016$'\t\\8dW&tw\rR3rk\u0016,\u0012a\u0018\t\u0004A\u0016<W\"A1\u000b\u0005\t\u001c\u0017AC2p]\u000e,(O]3oi*\u0011AmJ\u0001\u0005kRLG.\u0003\u0002gC\ni!\t\\8dW&tw-U;fk\u0016\u0004\"\u0001\n5\n\u0005%,#\u0001\u0003*v]:\f'\r\\3\t\r-\u0004\u0001\u0015!\u0003`\u0003Qa\u0017N\\6fI\ncwnY6j]\u001e$U-];fA!9Q\u000e\u0001b\u0001\n\u0003q\u0017aD3yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0016\u0003=\u0004\"\u0001\u00199\n\u0005E\f'aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\rM\u0004\u0001\u0015!\u0003p\u0003A)\u00070Z2vi>\u00148+\u001a:wS\u000e,\u0007\u0005C\u0003\u0004\u0001\u0011\u0005Q\u000fF\u0001w!\tyq/\u0003\u0002y!\t!QK\\5u\u0011\u0015Q\b\u0001\"\u0003|\u0003\u00199(/\u001b;feR\u0019A0a\u0003\u0011\u0007=ix0\u0003\u0002\u007f!\tIa)\u001e8di&|g\u000e\r\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0014\u0002\u0005%|\u0017\u0002BA\u0005\u0003\u0007\u0011aa\u0016:ji\u0016\u0014\bbBA\u0007s\u0002\u0007\u0011qB\u0001\u0005M&dW\r\u0005\u0003\u0002\u0002\u0005E\u0011\u0002BA\n\u0003\u0007\u0011AAR5mK\u001e9\u0011q\u0003\u0002\t\u0002\u0005e\u0011A\u0003#v[B,\u0005\u0010]8siB\u0019\u0011'a\u0007\u0007\r\u0005\u0011\u0001\u0012AA\u000f'\r\tYB\u0004\u0005\b]\u0005mA\u0011AA\u0011)\t\tI\u0002\u0003\u0005\u0002&\u0005mA\u0011AA\u0014\u0003\u0011i\u0017-\u001b8\u0015\u0007Y\fI\u0003\u0003\u0005\u0002,\u0005\r\u0002\u0019AA\u0017\u0003\u0011\t'oZ:\u0011\u0007=\u0019u\u0003")
public class DumpExport {
    private final String filename;
    private final Integer threads;
    private final Logger logger;
    private final Function1<URI, URI>[] policies;
    private final Destination destination;
    private final BlockingQueue<Runnable> linkedBlockingDeque;
    private final ExecutorService executorService;

    public static void main(String[] stringArray) {
        DumpExport$.MODULE$.main(stringArray);
    }

    public String filename() {
        return this.filename;
    }

    public Integer threads() {
        return this.threads;
    }

    public Logger logger() {
        return this.logger;
    }

    public Function1<URI, URI>[] policies() {
        return this.policies;
    }

    public Destination destination() {
        return this.destination;
    }

    public BlockingQueue<Runnable> linkedBlockingDeque() {
        return this.linkedBlockingDeque;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public void export() {
        Boolean bl;
        JDBCUtil.execSQL("SET names utf8");
        this.destination().open();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                conn = JDBCPoolConnection.getCachePoolConnection();
                conn.setAutoCommit(false);
                stmt = conn.createStatement(1003, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
                rs = stmt.executeQuery(DBpediaSQLQueries$.MODULE$.getJSONCacheSelectAll());
                while (rs.next()) {
                    Blob jsonBlob = rs.getBlob("json");
                    byte[] jsonData = jsonBlob.getBytes(1L, (int)jsonBlob.length());
                    String jsonString = new String(jsonData).trim();
                    if (jsonString.isEmpty()) continue;
                    this.executorService().execute(new QuadProcessWorker(this.destination(), jsonString));
                }
                rs.close();
                stmt.close();
            }
            catch (Exception exception) {
                this.logger().warn(exception.getMessage(), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Boolean bl2;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                this.logger().warn(exception.getMessage(), (Throwable)exception);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {
                this.logger().warn(exception.getMessage(), (Throwable)exception);
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                this.logger().warn(exception.getMessage(), (Throwable)exception);
            }
            this.executorService().shutdown();
            try {
                bl2 = BoxesRunTime.boxToBoolean((boolean)this.executorService().awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS));
            }
            catch (InterruptedException interruptedException) {
                this.logger().error("Error in thread termination", (Throwable)interruptedException);
                bl2 = BoxedUnit.UNIT;
            }
            this.destination().close();
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {
            this.logger().warn(exception.getMessage(), (Throwable)exception);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {
            this.logger().warn(exception.getMessage(), (Throwable)exception);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception exception) {
            this.logger().warn(exception.getMessage(), (Throwable)exception);
        }
        this.executorService().shutdown();
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)this.executorService().awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS));
        }
        catch (InterruptedException interruptedException) {
            this.logger().error("Error in thread termination", (Throwable)interruptedException);
            bl = BoxedUnit.UNIT;
        }
        this.destination().close();
    }

    private Function0<Writer> writer(File file) {
        return new Serializable(this, file){
            private final File file$1;

            public final Writer apply() {
                return IOUtils$.MODULE$.writer((FileLike)RichFile$.MODULE$.wrapFile(this.file$1), IOUtils$.MODULE$.writer$default$2());
            }
            {
                this.file$1 = file$1;
            }
        };
    }

    public DumpExport(String filename, Integer threads) {
        this.filename = filename;
        this.threads = threads;
        this.logger = LoggerFactory.getLogger(DumpExport.class);
        this.policies = UriPolicy$.MODULE$.parsePolicy((String)LiveOptions.options.get((Object)"uri-policy.main"));
        this.destination = new WriterDestination(this.writer(new File(filename)), (Formatter)new TerseFormatter(false, true, this.policies()));
        this.linkedBlockingDeque = new LinkedBlockingDeque<Runnable>(Predef$.MODULE$.Integer2int(threads) * 4);
        this.executorService = new ThreadPoolExecutor(Predef$.MODULE$.Integer2int(threads), Predef$.MODULE$.Integer2int(threads), 30L, TimeUnit.SECONDS, this.linkedBlockingDeque(), new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

