/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.sparql;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.util.ModelUtil;
import org.dbpedia.extraction.live.util.SQLUtil;
import org.dbpedia.extraction.live.util.sparql.ISparulExecutor;
import org.dbpedia.extraction.live.util.sparql.ModelChunkIterable;
import virtuoso.jdbc4.VirtuosoExtendedString;
import virtuoso.jdbc4.VirtuosoRdfBox;
import virtuoso.jdbc4.VirtuosoResultSet;

public class VirtuosoJdbcSparulExecutor
implements ISparulExecutor {
    private static final Logger logger = Logger.getLogger(VirtuosoJdbcSparulExecutor.class);
    private Connection con;
    private String defaultGraphName;
    private int ttlpFlags = 255;
    private int maxChunkSize = 1024;

    public VirtuosoJdbcSparulExecutor(String defaultGraphName) {
        this.defaultGraphName = defaultGraphName;
    }

    public VirtuosoJdbcSparulExecutor(Connection con, String defaultGraphName) {
        this.con = con;
        this.defaultGraphName = defaultGraphName;
    }

    public void setConnection(Connection connection) {
        this.con = connection;
    }

    public Connection getConnection() {
        return this.con;
    }

    public void setTTLPFlags(int ttlpFlags) {
        this.ttlpFlags = ttlpFlags;
    }

    public int getTTLPFlags() {
        return this.ttlpFlags;
    }

    @Override
    public void executeUpdate(String query) throws Exception {
        query = this.processRawQuery(query);
        Statement stmt = this.con.createStatement();
        stmt.executeUpdate(query);
    }

    private static String escapeQuery(String query) {
        query = query.replace("\\", "\\\\");
        query = query.replace("'", "\\'");
        return query;
    }

    private String processRawQuery(String query) {
        query = VirtuosoJdbcSparulExecutor.escapeQuery(query);
        if (this.getGraphName() != null) {
            query = "define input:default-graph-uri <" + this.getGraphName() + "> \n" + query;
        }
        query = "CALL DB.DBA.SPARQL_EVAL('" + query + "', NULL, 0)";
        return query;
    }

    @Override
    public boolean executeAsk(String query) throws Exception {
        query = this.processRawQuery(query);
        logger.trace((Object)("Sending query: " + query));
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        boolean result = false;
        while (rs.next()) {
            result = rs.getBoolean(1);
        }
        return result;
    }

    @Override
    public List<QuerySolution> executeSelect(String query) throws Exception {
        query = this.processRawQuery(query);
        logger.trace((Object)("Sending query: " + query));
        ArrayList<QuerySolution> result = new ArrayList<QuerySolution>();
        Statement stmt = this.con.createStatement();
        VirtuosoResultSet rs = (VirtuosoResultSet)stmt.executeQuery(query);
        ResultSetMetaData meta = rs.getMetaData();
        Model model = ModelFactory.createDefaultModel();
        while (rs.next()) {
            QuerySolutionMap qs = new QuerySolutionMap();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                String columnName = meta.getColumnName(i);
                Object o = rs.getObject(i);
                if (o instanceof VirtuosoExtendedString) {
                    VirtuosoExtendedString vs = (VirtuosoExtendedString)o;
                    if (vs.iriType == 1) {
                        qs.add(columnName, (RDFNode)model.createResource(vs.str));
                        continue;
                    }
                    if (vs.iriType != 2) continue;
                    qs.add(columnName, (RDFNode)model.createResource(new AnonId(vs.str)));
                    continue;
                }
                if (o instanceof VirtuosoRdfBox) {
                    VirtuosoRdfBox rb = (VirtuosoRdfBox)o;
                    if (rb.getType() == null || rb.getType().isEmpty()) {
                        qs.add(columnName, (RDFNode)model.createLiteral(rb.rb_box.toString(), rb.getLang()));
                        continue;
                    }
                    qs.add(columnName, (RDFNode)model.createTypedLiteral(rb.rb_box));
                    continue;
                }
                if (o == null) {
                    qs.add(columnName, null);
                    continue;
                }
                qs.add(columnName, (RDFNode)model.createLiteral(o.toString()));
            }
            result.add((QuerySolution)qs);
        }
        return result;
    }

    @Override
    public String getGraphName() {
        return this.defaultGraphName;
    }

    @Override
    public boolean insert(Model model, String graphName) throws SQLException {
        ModelChunkIterable chunks = new ModelChunkIterable(model, this.maxChunkSize);
        for (Model item : chunks) {
            this.insertBatch(item, graphName);
        }
        return true;
    }

    public boolean insertBatch(Model model, String graphName) throws SQLException {
        if (model.isEmpty()) {
            return true;
        }
        String ntriples = ModelUtil.toString(model, "N-TRIPLE");
        ntriples = ntriples.replace("\\", "\\\\");
        ntriples = ntriples.replace("'", "\\'");
        String query = "DB.DBA.TTLP_MT ('" + ntriples + "', '" + graphName + "', '" + graphName + "', " + this.ttlpFlags + ")";
        logger.trace((Object)("Sending query: " + query));
        Statement stmt = this.con.createStatement();
        boolean result = stmt.execute(query);
        stmt.close();
        return result;
    }

    public boolean removeBatch(Model model, String graphName) throws Exception {
        if (model.isEmpty()) {
            return false;
        }
        if (graphName == null) {
            graphName = this.defaultGraphName;
        }
        String ntriples = ModelUtil.toString(model, "N-TRIPLE");
        String query = "Delete ";
        if (graphName != null) {
            query = query + "From <" + graphName + "> ";
        }
        query = query + "{" + ntriples + "}";
        logger.trace((Object)("Sending query: " + query));
        this.executeUpdate(query);
        return true;
    }

    @Override
    public boolean remove(Model model, String graphName) throws Exception {
        ModelChunkIterable chunks = new ModelChunkIterable(model, this.maxChunkSize);
        for (Model item : chunks) {
            this.removeBatch(item, graphName);
        }
        return true;
    }

    @Override
    public Model executeConstruct(String query) throws Exception {
        query = VirtuosoJdbcSparulExecutor.escapeQuery(query);
        query = "sparql " + query;
        logger.trace((Object)("Sending query: " + query));
        String str = SQLUtil.execute(this.con, query, String.class, new Object[0]);
        ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes());
        Model result = ModelFactory.createDefaultModel();
        result.read((InputStream)in, null, "N3");
        return result;
    }
}

