/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.sparql;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import org.dbpedia.extraction.live.util.iterators.SinglePrefetchIterator;

class ModelChunkIterator
extends SinglePrefetchIterator<Model> {
    private Model model;
    private int maxChunkSize;
    private StmtIterator it;

    public ModelChunkIterator(Model model, int maxChunkSize) {
        this.model = model;
        this.maxChunkSize = maxChunkSize;
    }

    @Override
    protected Model prefetch() throws Exception {
        Model tmp = ModelFactory.createDefaultModel();
        if (this.it == null) {
            this.it = this.model.listStatements();
        }
        while (this.it.hasNext()) {
            tmp.add((Statement)this.it.next());
            if (tmp.size() <= (long)this.maxChunkSize) continue;
            return tmp;
        }
        if (!tmp.isEmpty()) {
            return tmp;
        }
        this.it.close();
        return (Model)this.finish();
    }
}

