/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.iterators;

import java.util.Iterator;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.util.ExceptionUtil;

public class RelativeDelayIterator<T>
implements Iterator<T> {
    private static Logger logger = Logger.getLogger(RelativeDelayIterator.class);
    private Iterator<T> iterator;
    private StopWatch stopWatch;
    private int delay;

    public RelativeDelayIterator(Iterator<T> iterator, int delay) {
        this.iterator = iterator;
        this.delay = delay;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.stopWatch == null) {
            this.stopWatch = new StopWatch();
        } else {
            this.stopWatch.stop();
            long delta = (long)this.delay - this.stopWatch.getTime();
            if (delta > 0L) {
                try {
                    logger.info((Object)("Waiting " + delta + " ms"));
                    Thread.sleep(delta, 0);
                }
                catch (Exception e) {
                    logger.warn((Object)ExceptionUtil.toString(e));
                }
            }
            this.stopWatch.reset();
        }
        this.stopWatch.start();
        T result = this.iterator.next();
        return result;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

