/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.iterators;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.util.ExceptionUtil;

public abstract class PrefetchIterator<T>
implements Iterator<T> {
    private static Logger logger = Logger.getLogger(PrefetchIterator.class);
    private Iterator<T> current = null;
    private boolean finished = false;

    protected abstract Iterator<T> prefetch() throws Exception;

    protected PrefetchIterator() {
    }

    private void preparePrefetch() {
        if (this.finished) {
            return;
        }
        this.current = null;
        try {
            this.current = this.prefetch();
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.toString(e));
        }
        if (this.current == null) {
            this.finished = true;
        }
    }

    private Iterator<T> getCurrent() {
        if (this.current == null || !this.current.hasNext()) {
            this.preparePrefetch();
        }
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.getCurrent() != null;
    }

    @Override
    public T next() {
        return this.getCurrent().next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

