/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.iterators;

import ORG.oclc.oai.harvester2.verb.ListRecords;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.util.DBPediaXPathUtil;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.dbpedia.extraction.live.util.iterators.PrefetchIterator;
import org.w3c.dom.Document;

public class OAIRecordIterator
extends PrefetchIterator<Document> {
    private static Logger logger = Logger.getLogger(OAIRecordIterator.class);
    private boolean endReached = false;
    private String resumptionToken = null;
    private String oaiBaseUri;
    private String startDate;
    private String endDate;
    private String lastResponseDate = null;
    private XPathExpression lastResponseDateExpr = null;
    private long pollDelay = 0L;
    private long prefetchDelay = 0L;
    private boolean firstRun = true;

    public String getLastResponseDate() {
        return this.lastResponseDate;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public OAIRecordIterator(String oaiBaseUri, String startDate, String endDate, long pollDelay, long prefetchDelay) {
        this.oaiBaseUri = oaiBaseUri;
        this.startDate = startDate;
        this.endDate = endDate;
        this.lastResponseDate = startDate;
        this.pollDelay = pollDelay;
        this.prefetchDelay = prefetchDelay;
        this.firstRun = true;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            this.lastResponseDateExpr = DBPediaXPathUtil.getOAIResponseDateExpr();
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.toString(e));
        }
    }

    @Override
    public Document next() {
        if (this.pollDelay > 0L) {
            try {
                Thread.sleep(this.pollDelay, 0);
            }
            catch (Exception e) {
                logger.warn((Object)ExceptionUtil.toString(e));
            }
        }
        return (Document)super.next();
    }

    @Override
    public Iterator<Document> prefetch() {
        try {
            long curPrefetchDelay = this.firstRun ? 0L : this.prefetchDelay;
            this.firstRun = false;
            if (this.endReached) {
                return null;
            }
            if (curPrefetchDelay > 0L) {
                Thread.sleep(curPrefetchDelay, 0);
            }
            ListRecords listRecords = null;
            listRecords = this.resumptionToken == null ? new ListRecords(this.oaiBaseUri, this.startDate, this.endDate, null, "mediawiki") : new ListRecords(this.oaiBaseUri, this.resumptionToken);
            logger.debug((Object)("Executed: " + listRecords.getRequestURL()));
            this.resumptionToken = listRecords.getResumptionToken();
            if (this.resumptionToken != null && !this.resumptionToken.trim().isEmpty()) {
                logger.debug((Object)("Got resumptionToken: '" + this.resumptionToken + "'"));
            } else {
                this.endReached = true;
            }
            Document document = listRecords.getDocument();
            this.lastResponseDate = (String)this.lastResponseDateExpr.evaluate(document, XPathConstants.STRING);
            return Collections.singleton(document).iterator();
        }
        catch (Exception e) {
            logger.warn((Object)ExceptionUtil.toString(e));
            return null;
        }
    }
}

