/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.iterators;

import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.util.iterators.OAIRecordIterator;
import org.dbpedia.extraction.live.util.iterators.PrefetchIterator;
import org.w3c.dom.Document;

public class EndlessOAIMetaIterator
extends PrefetchIterator<Document> {
    private static Logger logger = Logger.getLogger(EndlessOAIMetaIterator.class);
    private String oaiBaseUri = null;
    private String startDate = null;
    private String endDate = null;
    private long pollDelay = 0L;
    private long resumptionDelay = 0L;
    private OAIRecordIterator lastIterator = null;

    public EndlessOAIMetaIterator(String oaiBaseUri, String startDate, long pollDelay, long resumptionDelay) {
        this.oaiBaseUri = oaiBaseUri;
        this.startDate = startDate;
        this.pollDelay = pollDelay;
        this.resumptionDelay = resumptionDelay;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getendDate() {
        return this.endDate;
    }

    @Override
    protected Iterator<Document> prefetch() {
        OAIRecordIterator it;
        if (this.lastIterator != null) {
            this.startDate = this.lastIterator.getLastResponseDate();
        }
        logger.trace((Object)("Using date: " + this.startDate));
        OAIRecordIterator iterator = it = new OAIRecordIterator(this.oaiBaseUri, this.startDate, null, this.pollDelay, this.resumptionDelay);
        this.lastIterator = it;
        return Collections.singletonList(iterator).get(0);
    }
}

