/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.iterators;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.util.OAIUtil;
import org.dbpedia.extraction.live.util.iterators.DuplicateOAIRecordRemoverIterator;
import org.dbpedia.extraction.live.util.iterators.PrefetchIterator;

public class DuplicateFeederItemRemoverIterator
extends PrefetchIterator<LiveQueueItem> {
    private Logger logger = Logger.getLogger(DuplicateOAIRecordRemoverIterator.class);
    private Iterator<LiveQueueItem> iterator;
    private Date currentTimestamp = new Date(0L);
    private Set<Long> currentIdentifiers = new HashSet<Long>();
    private DateFormat dateFormat = new SimpleDateFormat(OAIUtil.getOAIDateFormatString());

    public DuplicateFeederItemRemoverIterator(Iterator<LiveQueueItem> iterator) {
        this.iterator = iterator;
    }

    @Override
    protected Iterator<LiveQueueItem> prefetch() throws Exception {
        while (this.iterator.hasNext()) {
            LiveQueueItem item = this.iterator.next();
            Date timestamp = this.dateFormat.parse(item.getModificationDate());
            if (timestamp.after(this.currentTimestamp)) {
                this.currentTimestamp = timestamp;
                this.currentIdentifiers.clear();
            }
            if (this.currentIdentifiers.contains(item.getItemID())) {
                this.logger.debug((Object)("Skipping duplicate: " + timestamp + ": " + item.getItemID()));
                continue;
            }
            this.currentIdentifiers.add(item.getItemID());
            return Collections.singleton(item).iterator();
        }
        return null;
    }
}

