/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dbpedia.extraction.live.util.collections.IDistanceFunc;

public class TimeStampSet<K, T, D>
implements Set<K> {
    private static final long serialVersionUID = -4277098373746171836L;
    private Map<K, T> keyToTime = new HashMap<K, T>();
    private TreeMap<T, Set<K>> sortedTimes = new TreeMap();
    private T currentTime;
    private IDistanceFunc<T, D> funcDistance;
    private D maxDistance;
    private Comparator<D> compDistance;
    private boolean inclusive;
    private boolean allowRenewal;

    public T getKeyTime(K key) {
        return this.keyToTime.get(key);
    }

    public TimeStampSet(IDistanceFunc<T, D> funcDistance, D maxDistance, Comparator<D> compDistance, boolean inclusive, boolean allowRenewal) {
        this.funcDistance = funcDistance;
        this.maxDistance = maxDistance;
        this.compDistance = compDistance;
        this.inclusive = inclusive;
        this.allowRenewal = allowRenewal;
    }

    public TimeStampSet(D maxDistance) {
        this.setMaxDistance(maxDistance);
    }

    private boolean isOutdated(T t) {
        D distance = this.funcDistance.distance(t, this.currentTime);
        int delta = this.compDistance.compare(distance, this.maxDistance);
        if (this.inclusive) {
            return delta > 0;
        }
        return delta >= 0;
    }

    private Set<K> removeOutdated() {
        HashSet<K> result = new HashSet<K>();
        while (!this.sortedTimes.isEmpty() && this.isOutdated(this.sortedTimes.firstKey())) {
            result.addAll(this.removeOldest());
        }
        return result;
    }

    public void setMaxDistance(D newMaxDistance) {
        this.maxDistance = newMaxDistance;
        this.removeOutdated();
    }

    private Set<K> removeOldest() {
        Map.Entry<T, Set<K>> removeItem = this.sortedTimes.pollFirstEntry();
        for (K removeKey : removeItem.getValue()) {
            this.keyToTime.remove(removeKey);
        }
        return removeItem.getValue();
    }

    private T initKeyTime(K key) {
        this.keyToTime.put(key, this.currentTime);
        Set<K> keys = this.sortedTimes.get(this.currentTime);
        if (keys == null) {
            keys = new HashSet<K>();
            this.sortedTimes.put(this.currentTime, keys);
        }
        keys.add(key);
        return this.currentTime;
    }

    private void updateKeyTime(K key, T oldTime) {
        Set<K> keys = this.sortedTimes.get(oldTime);
        if (!keys.contains(key)) {
            throw new RuntimeException("Shouldn't happen");
        }
        if (this.sortedTimes.size() == 1) {
            this.sortedTimes.remove(oldTime);
        } else {
            keys.remove(key);
        }
        this.initKeyTime(key);
    }

    public Set<K> setCurrentTime(T time) {
        this.currentTime = time;
        return this.removeOutdated();
    }

    @Override
    public boolean add(K key) {
        T keyTime = this.keyToTime.get(key);
        if (keyTime == null) {
            this.initKeyTime(key);
        } else if (this.allowRenewal) {
            this.updateKeyTime(key, keyTime);
        }
        return keyTime == null;
    }

    @Override
    public boolean addAll(Collection<? extends K> arg0) {
        boolean result = false;
        for (K item : arg0) {
            result |= this.add(item);
        }
        return result;
    }

    @Override
    public void clear() {
        this.keyToTime.clear();
        this.sortedTimes.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.keyToTime.containsKey(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        boolean result = true;
        for (Object item : arg0) {
            result &= this.contains(item);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.keyToTime.isEmpty();
    }

    @Override
    public Iterator<K> iterator() {
        return this.keyToTime.keySet().iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        T time = this.keyToTime.get(arg0);
        if (time == null) {
            return false;
        }
        Set<K> keys = this.sortedTimes.get(time);
        if (keys == null) {
            return false;
        }
        this.keyToTime.remove(arg0);
        if (keys.remove(arg0)) {
            if (keys.isEmpty()) {
                this.sortedTimes.remove(keys);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new RuntimeException("Not implemented yet.");
    }

    @Override
    public int size() {
        return this.keyToTime.size();
    }

    @Override
    public Object[] toArray() {
        return this.keyToTime.keySet().toArray();
    }

    @Override
    public <X> X[] toArray(X[] arg0) {
        return this.keyToTime.keySet().toArray(arg0);
    }

    @Override
    public int hashCode() {
        return this.keyToTime.keySet().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.keyToTime.keySet().equals(o);
    }

    public String toString() {
        return this.keyToTime.keySet().toString();
    }

    public static <K> TimeStampSet<K, Date, Long> createSet(Class<K> clazz, long maxDistance, boolean inclusive, boolean allowRenewal) {
        return new TimeStampSet<K, Date, Long>(new IDistanceFunc<Date, Long>(){

            @Override
            public Long distance(Date a, Date b) {
                return b.getTime() - a.getTime();
            }
        }, maxDistance, new Comparator<Long>(){

            @Override
            public int compare(Long a, Long b) {
                return a.compareTo(b);
            }
        }, inclusive, allowRenewal);
    }
}

