/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class StringUtil {
    public static List<String> matchAll(String text, Pattern pattern) {
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> result = new ArrayList<String>();
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                result.add(matcher.group(i));
            }
        }
        return result;
    }

    public static String noNull(String str) {
        return str == null ? "" : str;
    }

    public static byte[] zip(String str) {
        byte[] result = null;
        try {
            result = StringUtil._zip(str);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static byte[] _zip(String str) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream zipStream = new GZIPOutputStream(baos);
        OutputStreamWriter writer = new OutputStreamWriter(zipStream);
        writer.write(str);
        writer.close();
        return baos.toByteArray();
    }

    public static String unzip(byte[] bytes) {
        String result = null;
        try {
            result = StringUtil._unzip(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String _unzip(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        GZIPInputStream zipStream = new GZIPInputStream(in);
        InputStreamReader reader = new InputStreamReader(zipStream);
        BufferedReader br = new BufferedReader(reader);
        String result = "";
        String part = "";
        while ((part = br.readLine()) != null) {
            result = result + part;
        }
        return result;
    }

    public static String toString(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String result = "";
        while (null != (line = reader.readLine())) {
            result = result + line + "\n";
        }
        return result;
    }

    public static String toString(Object o) {
        return o == null ? "(null)" : o.toString();
    }

    public static String implode(String separator, Object ... items) {
        return StringUtil.implode(separator, Arrays.asList(items));
    }

    public static String implode(String separator, Iterator<? extends Object> it) {
        String result = "";
        if (it == null) {
            return null;
        }
        while (it.hasNext()) {
            result = result + it.next();
            if (!it.hasNext()) continue;
            result = result + separator;
        }
        return result;
    }

    public static String implode(String separator, Iterable<? extends Object> items) {
        return StringUtil.implode(separator, items.iterator());
    }

    public static String cropString(String str, int nMax, int nTolerance) {
        int tooMany;
        String result = str;
        int nGiven = str.length();
        if (nGiven > nMax && (tooMany = nGiven - nMax) > nTolerance) {
            result = str.substring(0, nMax) + "... (" + tooMany + " more bytes)";
        }
        return result;
    }

    public static String ucFirst(String str) {
        return str.length() == 0 ? "" : str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String lcFirst(String str) {
        return str.length() == 0 ? "" : str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String trim(String str) {
        return str == null ? "" : str.trim();
    }

    public static String ucFirstOnly(String str) {
        String tmp = StringUtil.noNull(str).trim().toLowerCase();
        return StringUtil.ucFirst(tmp);
    }
}

