/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class SQLUtil {
    private static final Logger logger = Logger.getLogger(SQLUtil.class);
    private static Pattern singleLineCommentPattern = Pattern.compile("^--.*$", 8);
    private static Pattern functionPattern = Pattern.compile("CREATE\\s+FUNCTION.*\\sAS\\s+(.*)\\s", 2);

    public static String placeHolder(int n, int m) {
        String part = "";
        for (int i = m - 1; i >= 0; --i) {
            part = part + "?";
            if (i == 0) continue;
            part = part + ", ";
        }
        if (m > 1) {
            part = "(" + part + ")";
        }
        String result = "";
        for (int j = n - 1; j >= 0; --j) {
            result = result + part;
            if (j == 0) continue;
            result = result + ", ";
        }
        return result;
    }

    public static List<String> parseSQLScript(String data) {
        data = data.replaceAll("/\\*.*\\*/", "");
        Matcher matcher = singleLineCommentPattern.matcher(data);
        data = matcher.replaceAll("");
        String[] parts = data.split(";");
        Stack<String> stack = new Stack<String>();
        ArrayList<String> result = new ArrayList<String>();
        String current = "";
        for (String part : parts) {
            String tos;
            part = part.trim();
            while (!stack.isEmpty() && part.contains(tos = (String)stack.peek())) {
                stack.pop();
            }
            if (!current.isEmpty()) {
                current = current + ";";
            }
            if (part.isEmpty()) continue;
            current = current + part;
            Matcher m = functionPattern.matcher(part);
            if (m.find()) {
                String delim = m.group(1);
                stack.push(delim);
            }
            if (!stack.isEmpty()) continue;
            result.add(current);
            current = "";
        }
        return result;
    }

    public static <T> T single(ResultSet rs, Class<T> clazz) throws SQLException {
        return SQLUtil.single(rs, clazz, true);
    }

    public static <T> T single(ResultSet rs, Class<T> clazz, boolean bClose) throws SQLException {
        if (rs.getMetaData().getColumnCount() != 1) {
            throw new RuntimeException("only a single column expected");
        }
        Object result = null;
        if (rs.next()) {
            Object o;
            result = o = rs.getObject(1);
            if (rs.next()) {
                throw new RuntimeException("only at most 1 row expected");
            }
        }
        if (bClose) {
            rs.close();
        }
        return (T)result;
    }

    public static <T> List<T> list(ResultSet rs, Class<T> clazz) throws SQLException {
        return SQLUtil.list(rs, clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> list(ResultSet rs, Class<T> clazz, boolean bClose) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            while (rs.next()) {
                Object o;
                Object item = o = rs.getObject(1);
                result.add(item);
            }
        }
        finally {
            if (bClose) {
                rs.close();
            }
        }
        return result;
    }

    public static <T> void executeSetArgs(PreparedStatement stmt, Object ... args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            stmt.setObject(i + 1, args[i]);
        }
        int n = stmt.getParameterMetaData().getParameterCount();
        for (int i = args.length; i < n; ++i) {
            stmt.setObject(i + 1, null);
        }
    }

    public static <T> T execute(Connection conn, String sql, Class<T> clazz, Object ... args) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(sql);
        T result = SQLUtil.execute(stmt, clazz, args);
        stmt.close();
        return result;
    }

    public static ResultSet executeCore(Connection conn, String sql, Object ... args) throws SQLException {
        logger.trace((Object)("Executing statement '" + sql + "' with args " + Arrays.asList(args)));
        PreparedStatement stmt = conn.prepareStatement(sql);
        SQLUtil.executeSetArgs(stmt, args);
        ResultSet result = stmt.executeQuery();
        return result;
    }

    public static ResultSet execute(PreparedStatement stmt, Object ... args) throws SQLException {
        SQLUtil.executeSetArgs(stmt, args);
        ResultSet result = stmt.executeQuery();
        return result;
    }

    public static <T> T execute(PreparedStatement stmt, Class<T> clazz, Object ... args) throws SQLException {
        SQLUtil.executeSetArgs(stmt, args);
        T result = null;
        if (clazz == null || Void.class.equals(clazz)) {
            stmt.execute();
        } else {
            ResultSet rs = stmt.executeQuery();
            result = SQLUtil.single(rs, clazz);
            rs.close();
        }
        return result;
    }

    public static <T> List<T> executeList(Connection conn, String sql, Class<T> clazz, Object ... args) throws SQLException {
        logger.trace((Object)("Executing statement '" + sql + "' with args " + Arrays.asList(args)));
        PreparedStatement stmt = conn.prepareStatement(sql);
        List<T> result = SQLUtil.executeList(stmt, clazz, args);
        stmt.close();
        return result;
    }

    public static <T> List<T> executeList(PreparedStatement stmt, Class<T> clazz, Object ... args) throws SQLException {
        SQLUtil.executeSetArgs(stmt, args);
        ResultSet rs = stmt.executeQuery();
        List<T> result = SQLUtil.list(rs, clazz);
        return result;
    }

    public static void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static String escapePostgres(Object o) {
        return o.toString().replace("\\", "\\\\").replace("'", "\\'");
    }

    public static String quotePostgres(Object o) {
        if (o == null) {
            return null;
        }
        return "E'" + SQLUtil.escapePostgres(o) + "'";
    }

    public static List<String> quotePostgres(Iterable<?> items) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object item : items) {
            result.add(SQLUtil.quotePostgres(item));
        }
        return result;
    }
}

