/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.xml.xpath.XPathExpression;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.iterators.TransformIterator;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.transformer.NodeToDocumentTransformer;
import org.dbpedia.extraction.live.transformer.NodeToLiveQueueItemTransformer;
import org.dbpedia.extraction.live.util.DBPediaXPathUtil;
import org.dbpedia.extraction.live.util.DateUtil;
import org.dbpedia.extraction.live.util.iterators.DuplicateFeederItemRemoverIterator;
import org.dbpedia.extraction.live.util.iterators.DuplicateOAIRecordRemoverIterator;
import org.dbpedia.extraction.live.util.iterators.EndlessOAIMetaIterator;
import org.dbpedia.extraction.live.util.iterators.XPathQueryIterator;
import org.w3c.dom.Document;

public class OAIUtil {
    private static String getStartDate(String date) {
        return date == null ? DateUtil.transformToUTC(System.currentTimeMillis()) : date;
    }

    public static Iterator<LiveQueueItem> createEndlessFeederItemIterator(String oaiBaseUri, String startDate, long pollDelay, long resumptionDelay) {
        XPathExpression expr = DBPediaXPathUtil.getRecordExpr();
        EndlessOAIMetaIterator metaIterator = new EndlessOAIMetaIterator(oaiBaseUri, startDate, pollDelay, resumptionDelay);
        XPathQueryIterator nodeIterator = new XPathQueryIterator(metaIterator, expr);
        TransformIterator dirtyRecordIterator = new TransformIterator((Iterator)nodeIterator, (Transformer)new NodeToLiveQueueItemTransformer());
        DuplicateFeederItemRemoverIterator recordIterator = new DuplicateFeederItemRemoverIterator((Iterator<LiveQueueItem>)dirtyRecordIterator);
        return recordIterator;
    }

    public static Iterator<Document> createEndlessRecordIterator(String oaiBaseUri, String startDate, long relativeEndFromNow, long pollDelay, long resumptionDelay) {
        XPathExpression expr = DBPediaXPathUtil.getRecordExpr();
        EndlessOAIMetaIterator metaIterator = new EndlessOAIMetaIterator(oaiBaseUri, startDate, pollDelay, resumptionDelay);
        XPathQueryIterator nodeIterator = new XPathQueryIterator(metaIterator, expr);
        TransformIterator dirtyRecordIterator = new TransformIterator((Iterator)nodeIterator, (Transformer)new NodeToDocumentTransformer());
        DuplicateOAIRecordRemoverIterator recordIterator = new DuplicateOAIRecordRemoverIterator((Iterator<Document>)dirtyRecordIterator);
        return recordIterator;
    }

    public static String getOAIDateFormatString() {
        return "yyyy-mm-dd'T'HH:mm:ss'Z'";
    }

    public static DateFormat getOAIDateFormat() {
        return new SimpleDateFormat(OAIUtil.getOAIDateFormatString());
    }
}

