/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;

public class ModelUtil {
    public static Model filterBySubject(Model model, Resource resource) {
        StmtIterator it = model.listStatements(resource, (Property)null, (RDFNode)null);
        Model result = ModelFactory.createDefaultModel();
        result.setNsPrefixes(model.getNsPrefixMap());
        while (it.hasNext()) {
            result.add((Statement)it.next());
        }
        return result;
    }

    public static Model combine(Collection<Model> models) {
        Model result = ModelFactory.createDefaultModel();
        for (Model model : models) {
            result.add(model);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model read(Model model, File file, String lang) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            model.read((InputStream)in, null, lang);
        }
        return model;
    }

    public static String toString(Model model) {
        return ModelUtil.toString(model, "N3");
    }

    public static String toString(Model model, RDFWriter writer) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.write(model, (OutputStream)baos, "");
        return baos.toString();
    }

    public static String toString(Model model, String format) {
        if (model == null) {
            return "null";
        }
        RDFWriter writer = model.getWriter(format);
        return ModelUtil.toString(model, writer);
    }
}

