/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.util.DateUtil;
import org.dbpedia.extraction.live.util.ExceptionUtil;

public class LastResponseDateManager {
    private static Logger logger = Logger.getLogger(LastResponseDateManager.class);

    public static String getNow() {
        return DateUtil.transformToUTC(new Date());
    }

    public static String getLastResponseDate(String strFileName) {
        File file = new File(strFileName);
        return LastResponseDateManager.getLastResponseDate(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastResponseDate(File file) {
        if (!file.exists()) {
            return null;
        }
        String strLastResponseDate = null;
        FileInputStream fsLastResponseDateFile = null;
        try {
            int ch;
            fsLastResponseDateFile = new FileInputStream(file);
            strLastResponseDate = "";
            while ((ch = fsLastResponseDateFile.read()) != -1) {
                strLastResponseDate = strLastResponseDate + (char)ch;
            }
        }
        catch (Exception exp) {
            logger.error((Object)ExceptionUtil.toString(exp));
        }
        finally {
            try {
                if (fsLastResponseDateFile != null) {
                    fsLastResponseDateFile.close();
                }
            }
            catch (Exception exp) {
                logger.error((Object)("File " + file.getAbsolutePath() + " cannot be closed due to " + exp.getMessage()));
            }
        }
        return strLastResponseDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLastResponseDate(String strFileName, String strLastResponseDate) {
        FileOutputStream fsLastResponseDateFile = null;
        OutputStreamWriter osWriter = null;
        try {
            fsLastResponseDateFile = new FileOutputStream(strFileName);
            osWriter = new OutputStreamWriter(fsLastResponseDateFile);
            osWriter.write(strLastResponseDate);
            osWriter.flush();
        }
        catch (Exception exp) {
            logger.error((Object)ExceptionUtil.toString(exp));
        }
        finally {
            try {
                if (osWriter != null) {
                    osWriter.close();
                }
                if (fsLastResponseDateFile != null) {
                    fsLastResponseDateFile.close();
                }
            }
            catch (Exception exp) {
                logger.error((Object)("File " + strFileName + " cannot be closed due to " + exp.getMessage()));
            }
        }
    }
}

