/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.util;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;

public class Files {
    public static boolean debug = false;

    public static <K, V> void writeMap(String fileName, Map<K, V> map) throws FileNotFoundException {
        File file = new File(fileName);
        XMLEncoder out = new XMLEncoder(new FileOutputStream(file));
        out.writeObject(map);
        out.close();
    }

    public static Map readMap(String fileName) throws FileNotFoundException {
        File file = new File(fileName);
        XMLDecoder in = new XMLDecoder(new FileInputStream(file));
        return (Map)in.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws FileNotFoundException, IOException {
        StringBuffer content = new StringBuffer();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                content.append(line);
                content.append(System.getProperty("line.separator"));
            }
        }
        return content.toString();
    }

    public static String[] readFileAsArray(File file) throws FileNotFoundException, IOException {
        String content = Files.readFile(file);
        StringTokenizer st = new StringTokenizer(content, System.getProperty("line.separator"));
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToFile(Object obj, File file) {
        ObjectOutputStream oos = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectfromFile(File file) {
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ois = new ObjectInputStream(bis);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static synchronized void createFile(File file, String content) {
        block4: {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(content.getBytes());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (debug) {
                    System.exit(0);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!debug) break block4;
                System.exit(0);
            }
        }
    }

    public static synchronized void createGzippedFile(File file, String content) {
        block4: {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                GZIPOutputStream gos = new GZIPOutputStream(fos);
                gos.write(content.getBytes());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (debug) {
                    System.exit(0);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!debug) break block4;
                System.exit(0);
            }
        }
    }

    public static void appendFile(File file, String content) {
        block4: {
            try {
                FileOutputStream fos = new FileOutputStream(file, true);
                fos.write(content.getBytes());
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (debug) {
                    System.exit(0);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!debug) break block4;
                System.exit(0);
            }
        }
    }

    public static void clearFile(File file) {
        block2: {
            try {
                Files.createFile(file, "");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!debug) break block2;
                System.exit(0);
            }
        }
    }

    public static void deleteFile(File file) {
        block2: {
            try {
                file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!debug) break block2;
                System.exit(0);
            }
        }
    }

    public static void mkdir(String dir) {
        block3: {
            if (!new File(dir).exists()) {
                try {
                    new File(dir).mkdir();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!debug) break block3;
                    System.exit(0);
                }
            }
        }
    }

    public static void deleteDir(String dir) {
        File f = new File(dir);
        if (debug) {
            System.out.println(dir);
            System.exit(0);
        }
        String[] files = f.list();
        for (int i = 0; i < files.length; ++i) {
            Files.deleteFile(new File(dir + File.separator + files[i]));
        }
    }

    public static void backupDirectory(String dir) {
        File f = new File(dir);
        String backupDir = "tmp/" + System.currentTimeMillis();
        Files.mkdir("tmp");
        Files.mkdir(backupDir);
        if (debug) {
            System.out.println(dir);
            System.exit(0);
        }
        String[] files = f.list();
        try {
            for (int i = 0; i < files.length; ++i) {
                File target = new File(dir + File.separator + files[i]);
                if (target.isDirectory()) continue;
                String s = Files.readFile(target);
                Files.createFile(new File(backupDir + File.separator + files[i]), s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

