/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.transformer;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections15.Transformer;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.util.DBPediaXPathUtil;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.dbpedia.extraction.live.util.XMLUtil;
import org.dbpedia.extraction.live.util.XPathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NodeToLiveQueueItemTransformer
implements Transformer<Node, LiveQueueItem> {
    private static Logger logger = Logger.getLogger(NodeToLiveQueueItemTransformer.class);

    public LiveQueueItem transform(Node node) {
        Document document = null;
        try {
            if (node == null) {
                return null;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            document = dbf.newDocumentBuilder().newDocument();
            Node clone = document.importNode(node, true);
            document.appendChild(clone);
            String tmpID = XPathUtil.evalToString((Node)document, DBPediaXPathUtil.getOAIIdentifierExpr());
            long nodeItemID = tmpID.equals("") ? 0L : Long.parseLong(tmpID.substring(tmpID.lastIndexOf(":") + 1));
            String nodeItemName = XPathUtil.evalToString((Node)document, DBPediaXPathUtil.getTitleExpr());
            String nodeModificationDate = XPathUtil.evalToString((Node)document, DBPediaXPathUtil.getTimestampExpr());
            boolean nodeDeleted = XPathUtil.evalToString((Node)document, DBPediaXPathUtil.getOAIIsRecordDeletedExpr()).equals("deleted");
            String xml = XMLUtil.toString(document);
            return new LiveQueueItem(nodeItemID, nodeItemName, nodeModificationDate, nodeDeleted, xml);
        }
        catch (Exception e) {
            logger.warn((Object)ExceptionUtil.toString(e));
            return null;
        }
    }
}

