/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.storage;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.storage.DBpediaSQLQueries;
import org.dbpedia.extraction.live.storage.JDBCPoolConnection;
import org.dbpedia.extraction.live.storage.JSONCacheObject;
import org.dbpedia.extraction.live.util.DateUtil;

public class JDBCUtil {
    private static Logger logger = Logger.getLogger(JDBCUtil.class);

    public static boolean execSPARUL(String sparul) {
        String query = sparul;
        if (!sparul.startsWith("SPARQL")) {
            query = "SPARQL " + query;
        }
        return JDBCUtil.execSQL(query, true);
    }

    public static boolean execSQL(String query) {
        return JDBCUtil.execSQL(query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execSQL(String query, boolean sparql) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet result = null;
        try {
            conn = !sparql ? JDBCPoolConnection.getCachePoolConnection() : JDBCPoolConnection.getStorePoolConnection();
            stmt = conn.createStatement();
            result = stmt.executeQuery(query);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execPrepared(String preparedQuery, String[] parameterList) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            int i;
            conn = JDBCPoolConnection.getCachePoolConnection();
            stmt = conn.prepareStatement(preparedQuery);
            for (i = 0; i < parameterList.length; ++i) {
                stmt.setString(i + 1, parameterList[i]);
            }
            stmt.execute();
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONCacheObject getCacheContent(String query, long pageID) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            conn = JDBCPoolConnection.getCachePoolConnection();
            stmt = conn.prepareStatement(query);
            stmt.setLong(1, pageID);
            result = stmt.executeQuery();
            if (result.next()) {
                int timesUpdated = result.getInt("timesUpdated");
                Blob jsonBlob = result.getBlob("json");
                byte[] jsonData = jsonBlob.getBytes(1L, (int)jsonBlob.length());
                Blob subjectsBlob = result.getBlob("subjects");
                byte[] subjectsData = subjectsBlob.getBytes(1L, (int)subjectsBlob.length());
                JSONCacheObject jSONCacheObject = new JSONCacheObject(pageID, timesUpdated, new String(jsonData), new String(subjectsData));
                return jSONCacheObject;
            }
            JSONCacheObject timesUpdated = null;
            return timesUpdated;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
            JSONCacheObject jSONCacheObject = null;
            return jSONCacheObject;
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiveQueueItem> getCacheUnmodified(int daysAgo, long limit) {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<LiveQueueItem> items = null;
        try {
            conn = JDBCPoolConnection.getCachePoolConnection();
            stmt = conn.prepareStatement(DBpediaSQLQueries.getJSONCacheUnmodified());
            stmt.setInt(1, daysAgo);
            stmt.setLong(2, limit);
            result = stmt.executeQuery();
            items = new ArrayList<LiveQueueItem>((int)limit);
            while (result.next()) {
                long pageID = result.getLong("pageID");
                Timestamp t = result.getTimestamp("updated");
                String timestamp = DateUtil.transformToUTC(t.getTime());
                items.add(new LiveQueueItem(pageID, timestamp));
            }
            ArrayList<LiveQueueItem> pageID = items;
            return pageID;
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
            List<LiveQueueItem> list = null;
            return list;
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
        }
    }
}

