/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.storage;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.core.LiveOptions;

public class JDBCPoolConnection {
    private static Logger logger = Logger.getLogger(JDBCPoolConnection.class);
    private static BoneCP connectionStorePool = null;
    private static BoneCP connectionCachePool = null;

    protected JDBCPoolConnection() {
    }

    private static void initStoreConnection() {
        try {
            BoneCPConfig config = new BoneCPConfig();
            Class.forName((String)LiveOptions.options.get((Object)"store.class"));
            config.setJdbcUrl((String)LiveOptions.options.get((Object)"store.dsn"));
            config.setUsername((String)LiveOptions.options.get((Object)"store.user"));
            config.setPassword((String)LiveOptions.options.get((Object)"store.pw"));
            connectionStorePool = new BoneCP(config);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage());
            logger.fatal((Object)"Could not initialize DB connection! Exiting...");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection getStorePoolConnection() throws SQLException {
        if (connectionStorePool != null) return connectionStorePool.getConnection();
        Class<JDBCPoolConnection> clazz = JDBCPoolConnection.class;
        synchronized (JDBCPoolConnection.class) {
            if (connectionStorePool != null) return connectionStorePool.getConnection();
            JDBCPoolConnection.initStoreConnection();
            // ** MonitorExit[var0] (shouldn't be in output)
            return connectionStorePool.getConnection();
        }
    }

    private static void initCacheConnection() {
        try {
            BoneCPConfig config = new BoneCPConfig();
            Class.forName((String)LiveOptions.options.get((Object)"cache.class"));
            config.setJdbcUrl((String)LiveOptions.options.get((Object)"cache.dsn"));
            config.setUsername((String)LiveOptions.options.get((Object)"cache.user"));
            config.setPassword((String)LiveOptions.options.get((Object)"cache.pw"));
            connectionCachePool = new BoneCP(config);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage());
            logger.fatal((Object)"Could not initialize DB connection! Exiting...");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection getCachePoolConnection() throws SQLException {
        if (connectionCachePool != null) return connectionCachePool.getConnection();
        Class<JDBCPoolConnection> clazz = JDBCPoolConnection.class;
        synchronized (JDBCPoolConnection.class) {
            if (connectionCachePool != null) return connectionCachePool.getConnection();
            JDBCPoolConnection.initCacheConnection();
            // ** MonitorExit[var0] (shouldn't be in output)
            return connectionCachePool.getConnection();
        }
    }

    public static void shutdown() {
        if (connectionStorePool != null) {
            try {
                connectionStorePool.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

