/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.statistics;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.dbpedia.extraction.live.statistics.StatisticsItem;
import org.dbpedia.extraction.live.util.DateUtil;

public class StatisticsData {
    private static long stats1m = 0L;
    private static long stats5m = 0L;
    private static long stats1h = 0L;
    private static long stats1d = 0L;
    private static long statsAll = 0L;
    private static ConcurrentLinkedDeque<StatisticsItem> statisticsDetailedQueue = new ConcurrentLinkedDeque();
    private static ConcurrentLinkedDeque<Long> statisticsTimestampQueue = new ConcurrentLinkedDeque();

    protected StatisticsData() {
    }

    public static synchronized void setAllStats(long s1m, long s5m, long s1h, long s1d, long sall) {
        stats1m = s1m;
        stats5m = s5m;
        stats1h = s1h;
        stats1d = s1d;
        statsAll = sall;
    }

    public static synchronized void setStats1m(long value) {
        stats1m = value;
    }

    public static synchronized void setStats5m(long value) {
        stats5m = value;
    }

    public static synchronized void setStats1h(long value) {
        stats1h = value;
    }

    public static synchronized void setStats1d(long value) {
        stats1d = value;
    }

    public static synchronized void setStatsAll(long value) {
        statsAll = value;
    }

    public static void addItem(String pageName, String pageDBpediaURI, String pageWikipediaURI, int pageID, long pageTimestamp) {
        try {
            statisticsDetailedQueue.addFirst(new StatisticsItem(pageName, pageDBpediaURI, pageWikipediaURI, pageID, pageTimestamp));
            statisticsTimestampQueue.addFirst(pageTimestamp);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public static synchronized String generateStatistics(int noOfDetailedIntances) {
        long d;
        long now = System.currentTimeMillis();
        while (!statisticsTimestampQueue.isEmpty() && now - statisticsTimestampQueue.peekLast() > DateUtil.getDuration1DayMillis()) {
            statisticsTimestampQueue.pollLast();
            ++statsAll;
        }
        while (statisticsDetailedQueue.size() > noOfDetailedIntances) {
            statisticsDetailedQueue.pollLast();
        }
        stats1m = 0L;
        stats5m = 0L;
        stats1h = 0L;
        stats1d = 0L;
        Iterator<Long> timeIter = statisticsTimestampQueue.iterator();
        while (timeIter.hasNext() && (d = now - timeIter.next()) < DateUtil.getDuration1HourMillis()) {
            ++stats1h;
            if (d >= 5L * DateUtil.getDuration1MinMillis()) continue;
            ++stats5m;
            if (d >= DateUtil.getDuration1MinMillis()) continue;
            ++stats1m;
        }
        stats1d = statisticsTimestampQueue.size();
        StringBuffer sb = new StringBuffer("");
        sb.append("{");
        sb.append("\"upd1m\": \"" + stats1m + "\",\n");
        sb.append("\"upd5m\": \"" + stats5m + "\",\n");
        sb.append("\"upd1h\": \"" + stats1h + "\",\n");
        sb.append("\"upd1d\": \"" + stats1d + "\",\n");
        sb.append("\"updat\": \"" + statsAll + stats1d + "\",\n");
        sb.append("\"timestamp\": \"" + System.currentTimeMillis() + "\",\n");
        sb.append("\"latest\": [");
        Iterator<StatisticsItem> detIter = statisticsDetailedQueue.iterator();
        while (detIter.hasNext()) {
            StatisticsItem item = detIter.next();
            sb.append("\n{");
            sb.append("\"title\":\"" + item.getPageTitle() + "\",");
            sb.append("\"dbpediaURI\": \"" + item.getDBpediaURI() + "\",");
            sb.append("\"wikipediaURI\": \"" + item.getWikipediaURI() + "\",");
            sb.append("\"timestamp\": \"" + item.getTimestamp() + "\",");
            sb.append("\"delta\": \"" + item.getHasDelta() + "\"");
            sb.append("}");
            if (!detIter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]}");
        return sb.toString();
    }
}

