/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.statistics;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.statistics.StatisticsData;

public class Statistics {
    private static Logger logger = Logger.getLogger(Statistics.class);
    private final String statisticsFileName;
    private final int statisticsDetailedInstances;
    private final long statisticsUpdateInterval;
    private final long statisticsInitialDelay;
    private Timer timer = new Timer("DBpedia-Live Statistics Timer");

    public Statistics(String fileName, int detailedInstances, long updateInterval, long initialDelay) {
        this.statisticsFileName = fileName;
        this.statisticsDetailedInstances = detailedInstances;
        this.statisticsUpdateInterval = updateInterval;
        this.statisticsInitialDelay = initialDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStatistics() {
        InputStreamReader reader = null;
        try {
            File file = new File(this.statisticsFileName);
            if (!file.exists()) {
                file.mkdirs();
                file.createNewFile();
            } else {
                reader = new FileReader(this.statisticsFileName);
                LineNumberReader line = new LineNumberReader(reader);
                long t1m = Integer.parseInt(line.readLine());
                long t5m = Integer.parseInt(line.readLine());
                long t1h = Integer.parseInt(line.readLine());
                long t1d = Integer.parseInt(line.readLine());
                long tat = Integer.parseInt(line.readLine());
                StatisticsData.setAllStats(t1m, t5m, t1h, t1d, tat - t1d);
            }
        }
        catch (Exception exp) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException exp) {}
        }
    }

    public void stopStatistics() {
        this.timer.cancel();
    }

    public void startStatistics() {
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileWriter writer = null;
                try {
                    writer = new FileWriter(Statistics.this.statisticsFileName);
                    writer.write(StatisticsData.generateStatistics(Statistics.this.statisticsDetailedInstances));
                }
                catch (IOException exp) {
                    logger.error((Object)("DBpedia-live Statistics: Failed to generate statistics: " + exp.getMessage()), (Throwable)exp);
                }
                catch (Exception exp) {
                    logger.error((Object)("DBpedia-live Statistics: I/O Error: " + exp.getMessage()), (Throwable)exp);
                }
                finally {
                    try {
                        if (writer != null) {
                            ((Writer)writer).close();
                        }
                    }
                    catch (IOException exp) {
                        logger.error((Object)("DBpedia-live Statistics: I/O Error: " + exp.getMessage()), (Throwable)exp);
                    }
                }
            }
        }, this.statisticsInitialDelay, this.statisticsUpdateInterval);
    }
}

