/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.queue;

import org.dbpedia.extraction.live.queue.LiveQueuePriority;

public class LiveQueueItem
implements Comparable<LiveQueueItem> {
    private long itemID = 0L;
    private LiveQueuePriority itemPriority;
    private String itemName = "";
    private String modificationDate = "";
    private boolean deleted = false;
    private long statQueueAdd = 0L;
    private String xml = "";

    public LiveQueueItem(long itemID, String modificationDate) {
        this.itemID = itemID;
        this.modificationDate = modificationDate;
    }

    public LiveQueueItem(long itemID, String itemName, String modificationDate, boolean deleted, String xml) {
        this.itemID = itemID;
        this.itemName = itemName;
        this.modificationDate = modificationDate;
        this.deleted = deleted;
        this.xml = xml;
    }

    public long getItemID() {
        return this.itemID;
    }

    public void setPriority(LiveQueuePriority itemPriority) {
        this.itemPriority = itemPriority;
    }

    public LiveQueuePriority getPriority() {
        return this.itemPriority;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getModificationDate() {
        return this.modificationDate;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setStatQueueAdd(long t) {
        this.statQueueAdd = t == -1L ? System.currentTimeMillis() : t;
    }

    public long getStatQueueAdd() {
        return this.statQueueAdd;
    }

    @Override
    public int compareTo(LiveQueueItem item) {
        if (this.itemPriority != item.itemPriority) {
            return this.itemPriority.compareTo(item.itemPriority);
        }
        if (this.modificationDate == "" || item.modificationDate == "") {
            return 0;
        }
        if (this.itemPriority == LiveQueuePriority.UnmodifiedPagePriority) {
            return item.modificationDate.compareTo(this.modificationDate);
        }
        return this.modificationDate.compareTo(item.modificationDate);
    }
}

