/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.publisher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.log4j.Logger;

public class RDFDiffWriter {
    private static final Logger logger = Logger.getLogger(RDFDiffWriter.class);
    private String baseName;
    private boolean zip = false;

    public RDFDiffWriter(String baseName) {
        this.baseName = baseName;
    }

    public static void write(String triplesString, boolean added, String baseName, boolean zip) throws IOException {
        OutputStream tmp = null;
        OutputStream out = null;
        try {
            if (triplesString == null || triplesString.compareTo("") == 0) {
                return;
            }
            File file = new File(baseName);
            File parentDir = file.getParentFile();
            if (parentDir != null) {
                parentDir.mkdir();
            }
            String fileNameExtension = "nt";
            if (zip) {
                fileNameExtension = fileNameExtension + ".gz";
            }
            String fileName = "";
            fileName = added ? baseName + ".added." + fileNameExtension : baseName + ".removed." + fileNameExtension;
            logger.info((Object)("Attempting to write diff-file: " + fileName));
            File outputFile = new File(fileName);
            logger.info((Object)fileName);
            tmp = new FileOutputStream(outputFile);
            out = zip ? new GzipCompressorOutputStream(tmp) : tmp;
            out.write(triplesString.getBytes());
            out.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (tmp != null) {
                tmp.close();
            }
        }
    }
}

