/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.publisher;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbpedia.extraction.live.main.Main;
import org.dbpedia.extraction.live.publisher.DiffData;
import org.dbpedia.extraction.live.publisher.RDFDiffWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Publisher
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(Publisher.class);
    HashSet<String> addedTriples = new HashSet();
    HashSet<String> deletedTriples = new HashSet();
    private Map<String, String> config;
    private long sequenceNumber = 0L;
    private static long fileNumber = 0L;
    private static int hourNumber = -1;
    private String publishDiffBaseName;
    Publisher liveSync;

    public Publisher(String name, int priority) {
        this.setPriority(priority);
        this.setName(name);
        this.initSync();
        this.start();
    }

    public Publisher(String name) {
        this(name, 5);
    }

    public Publisher() {
        this("Publisher", 5);
    }

    public static Map<String, String> loadIniFile(File file) throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        Publisher.loadIniFile(file, config);
        return config;
    }

    public static void loadIniFile(File file, Map<String, String> out) throws IOException {
        BufferedReader rdr = new BufferedReader(new FileReader(file));
        Publisher.loadIniFile(rdr, out);
        rdr.close();
    }

    public static void loadIniFile(BufferedReader reader, Map<String, String> out) throws IOException {
        String line;
        String SOURCE = "source";
        Pattern pattern = Pattern.compile("\\s*([^=]*)\\s*=\\s*(.*)\\s*");
        ArrayList<String> loadFileNames = new ArrayList<String>();
        String tmp = "";
        while ((line = reader.readLine()) != null) {
            line.trim();
            if (line.startsWith(SOURCE)) {
                String fileName = line.substring(SOURCE.length()).trim();
                loadFileNames.add(fileName);
                continue;
            }
            Matcher m = pattern.matcher(line);
            if (!m.find()) continue;
            String key = m.group(1);
            String value = m.group(2);
            out.put(key, value);
        }
        for (String loadFileName : loadFileNames) {
            File file = new File(loadFileName);
            Publisher.loadIniFile(file, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLastPublishDate(String strFileName) {
        String strLastResponseDate = null;
        FileInputStream fsLastPublishDateFile = null;
        try {
            fsLastPublishDateFile = new FileInputStream(strFileName);
            DataInputStream in = new DataInputStream(fsLastPublishDateFile);
            BufferedReader rdr = new BufferedReader(new InputStreamReader(in));
            strLastResponseDate = "";
            strLastResponseDate = rdr.readLine();
            if (strLastResponseDate != null) {
                logger.info(strLastResponseDate);
            }
        }
        catch (Exception exp) {
            logger.warn("Last publish date cannot be read due to " + exp.getMessage());
            logger.info("Assuming the last publish date is now");
            exp.printStackTrace();
        }
        finally {
            try {
                if (fsLastPublishDateFile != null) {
                    fsLastPublishDateFile.close();
                }
            }
            catch (Exception exp) {
                logger.warn("File " + strFileName + " cannot be closed due to " + exp.getMessage());
            }
        }
        return strLastResponseDate;
    }

    public Publisher(Map<String, String> config) throws Exception {
        this.config = config;
        this.publishDiffBaseName = config.get("publishDiffRepoPath");
    }

    public void initSync() {
        try {
            String configFileName = "./live.ini";
            File configFile = new File(configFileName);
            Map<String, String> config = Publisher.loadIniFile(configFile);
            this.liveSync = new Publisher(config);
            String lastPublishedFilename = Publisher.getLastPublishDate(this.liveSync.publishDiffBaseName + "/lastPublishedFile.txt");
            this.setCorrectFileNumber(lastPublishedFilename);
        }
        catch (Exception exp) {
            logger.error("Publisher cannot be initialized ");
        }
    }

    private void setCorrectFileNumber(String lastPublishedFilename) {
        if (lastPublishedFilename.compareTo("") == 0) {
            this.sequenceNumber = 0L;
        }
        Calendar currentDateCalendar = Calendar.getInstance();
        String[] parts = lastPublishedFilename.split("-");
        int year = Integer.parseInt(parts[0]);
        int month = Integer.parseInt(parts[1]);
        int day = Integer.parseInt(parts[2]);
        int hour = Integer.parseInt(parts[3]);
        if (currentDateCalendar.get(11) == hour && currentDateCalendar.get(5) == day && currentDateCalendar.get(2) + 1 == month && currentDateCalendar.get(1) == year) {
            fileNumber = Integer.parseInt(parts[4]) + 1;
            hourNumber = hour;
        } else {
            hourNumber = -1;
            fileNumber = 0L;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    DiffData pubData = Main.publishingDataQueue.take();
                    this.liveSync.step(pubData);
                }
            }
            catch (Throwable t) {
                logger.error("An exception was encountered in the Publisher update loop", t);
                continue;
            }
            break;
        }
    }

    private void step(DiffData pubData) throws Exception {
        String filename = this.config.get("osmReplicationConfigPath") + "/state.txt";
        File osmStateFile = new File(filename);
        Publisher.loadIniFile(osmStateFile, this.config);
        this.publishDiff(pubData, this.sequenceNumber);
        ++this.sequenceNumber;
    }

    private void publishDiff(DiffData pubData, long id) throws IOException {
        String fileName;
        File parent;
        Calendar currentDateCalendar = Calendar.getInstance();
        if (hourNumber != currentDateCalendar.get(11)) {
            hourNumber = currentDateCalendar.get(11);
            id = 0L;
            this.sequenceNumber = 0L;
            fileNumber = 0L;
        }
        if ((parent = new File(fileName = this.publishDiffBaseName + "/" + currentDateCalendar.get(1) + "/" + String.format("%02d", currentDateCalendar.get(2) + 1) + "/" + String.format("%02d", currentDateCalendar.get(5)) + "/" + String.format("%02d", currentDateCalendar.get(11)) + "/" + this.format(fileNumber)).getParentFile()) != null) {
            parent.mkdirs();
        }
        if (pubData != null) {
            this.addedTriples.addAll(pubData.toAdd);
            this.deletedTriples.addAll(pubData.toDelete);
        }
        if (this.sequenceNumber % 300L == 0L) {
            StringBuilder addString = new StringBuilder();
            for (String s : this.addedTriples) {
                addString.append(s);
                addString.append('\n');
            }
            RDFDiffWriter.write(addString.toString(), true, fileName, true);
            this.addedTriples.clear();
            StringBuilder delString = new StringBuilder();
            for (String s : this.deletedTriples) {
                delString.append(s);
                delString.append('\n');
            }
            RDFDiffWriter.write(delString.toString(), false, fileName, true);
            this.deletedTriples.clear();
            ++fileNumber;
            this.writeLastPublishedFileSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLastPublishedFileSequence() {
        Calendar currentDateCalendar = Calendar.getInstance();
        String lastPublishedFile = currentDateCalendar.get(1) + "-" + String.format("%02d", currentDateCalendar.get(2) + 1) + "-" + String.format("%02d", currentDateCalendar.get(5)) + "-" + String.format("%02d", currentDateCalendar.get(11)) + "-" + this.format(fileNumber);
        FileOutputStream fsLastProcessingDateFile = null;
        OutputStreamWriter osWriter = null;
        try {
            fsLastProcessingDateFile = new FileOutputStream(this.publishDiffBaseName + "/lastPublishedFile.txt");
            osWriter = new OutputStreamWriter(fsLastProcessingDateFile);
            osWriter.write(lastPublishedFile);
            osWriter.close();
        }
        catch (Exception exp) {
            logger.warn("The date of last Processing process cannot be written to file.\n");
        }
        finally {
            try {
                if (osWriter != null) {
                    osWriter.close();
                }
                if (fsLastProcessingDateFile != null) {
                    fsLastProcessingDateFile.close();
                }
            }
            catch (Exception exp) {
                logger.error("File lastPublishedFile.txt cannot be closed due to " + exp.getMessage());
            }
        }
    }

    private String format(long value) {
        String result = String.format("%06d", value);
        return result;
    }
}

