/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.publisher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.log4j.Logger;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.dbpedia.extraction.live.core.LiveOptions;

public class PublishedDataCompressor
extends Thread {
    Logger logger = Logger.getLogger(PublishedDataCompressor.class);
    private Date lastProcessingDate = new Date();
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH");

    public PublishedDataCompressor(String name, int priority) {
        this.setPriority(priority);
        this.setName(name);
        this.start();
    }

    public PublishedDataCompressor(String name) {
        this(name, 1);
    }

    public PublishedDataCompressor() {
        this("PublishedDataCompressor", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String publishBaseName = (String)LiveOptions.options.get((Object)"publishDiffRepoPath");
            String lastProcessingDateFilename = publishBaseName + "/lastProcessingDate.dat";
            this.lastProcessingDate = this._readLastProcessingDateFromFile(lastProcessingDateFilename);
            while (true) {
                try {
                    while (true) {
                        CompressionDate lastCompressionDate = new CompressionDate(this.lastProcessingDate);
                        CompressionDate currentCompressionDate = new CompressionDate(new Date());
                        if (currentCompressionDate.getYear() != lastCompressionDate.getYear()) {
                            this.compressYear(dateFormatter.format(this.lastProcessingDate));
                        } else if (currentCompressionDate.getMonth() != lastCompressionDate.getMonth()) {
                            this.compressMonth(dateFormatter.format(this.lastProcessingDate));
                        } else if (currentCompressionDate.getDay() != lastCompressionDate.getDay()) {
                            this.compressDay(dateFormatter.format(this.lastProcessingDate));
                        } else {
                            if (currentCompressionDate.getHour() == lastCompressionDate.getHour()) continue;
                            this.compressHour(dateFormatter.format(this.lastProcessingDate));
                        }
                        this._writeLastProcessingDateToFile(lastProcessingDateFilename);
                        this.lastProcessingDate = this._readLastProcessingDateFromFile(lastProcessingDateFilename);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exp) {
            this.logger.error((Object)("Published data cannot be compressed due to " + exp.getMessage()));
        }
    }

    private void compressPublishData(Date lastProcessing) {
        Date currentDate = new Date();
        String strCurrentDate = dateFormatter.format(currentDate);
        String[] currentDateParts = strCurrentDate.split("-");
        int currentYear = Integer.parseInt(currentDateParts[0]);
        int currentMonth = Integer.parseInt(currentDateParts[1]);
        int currentDay = Integer.parseInt(currentDateParts[2]);
        int currentHour = Integer.parseInt(currentDateParts[3]);
        String[] lastProcessingDateParts = dateFormatter.format(lastProcessing).split("-");
        int lastProcessingYear = Integer.parseInt(lastProcessingDateParts[0]);
        int lastProcessingMonth = Integer.parseInt(lastProcessingDateParts[1]);
        int lastProcessingDay = Integer.parseInt(lastProcessingDateParts[2]);
        int lastProcessingHour = Integer.parseInt(lastProcessingDateParts[3]);
        if (currentYear != lastProcessingYear) {
            this.compressYear(dateFormatter.format(lastProcessing));
        } else if (currentMonth != lastProcessingMonth) {
            this.compressMonth(dateFormatter.format(lastProcessing));
        } else if (currentDay != lastProcessingDay) {
            this.compressDay(dateFormatter.format(lastProcessing));
        } else if (currentHour != lastProcessingHour) {
            this.compressHour(dateFormatter.format(lastProcessing));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date _readLastProcessingDateFromFile(String filename) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH");
        BufferedReader inputReader = null;
        try {
            inputReader = new BufferedReader(new FileReader(filename));
            String line = inputReader.readLine();
            Date date = dateFormatter.parse(line);
            return date;
        }
        catch (Exception exp) {
            this.logger.warn((Object)"The date of last Processing process cannot be read from file.\nAssuming it is the current date");
            Date date = new Date();
            return date;
        }
        finally {
            try {
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (Exception exp) {
                this.logger.error((Object)("File " + filename + " cannot be closed due to " + exp.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeLastProcessingDateToFile(String filename) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH");
        FileOutputStream fsLastProcessingDateFile = null;
        OutputStreamWriter osWriter = null;
        try {
            fsLastProcessingDateFile = new FileOutputStream(filename);
            osWriter = new OutputStreamWriter(fsLastProcessingDateFile);
            osWriter.write(dateFormatter.format(new Date()));
        }
        catch (Exception exp) {
            this.logger.warn((Object)"The date of last Processing process cannot be written to file.\n");
        }
        finally {
            try {
                if (osWriter != null) {
                    osWriter.close();
                }
            }
            catch (Exception exp) {
                this.logger.error((Object)("File " + filename + " cannot be closed due to " + exp.getMessage()));
            }
            try {
                if (fsLastProcessingDateFile != null) {
                    fsLastProcessingDateFile.close();
                }
            }
            catch (Exception exp) {
                this.logger.error((Object)("File " + filename + " cannot be closed due to " + exp.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLastProcessingDateFromFile(String filename, Date lastProcessing) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH");
        FileWriter writer = null;
        try {
            writer = new FileWriter(filename);
            writer.write(dateFormatter.format(lastProcessing));
            writer.flush();
        }
        catch (Exception exp) {
            this.logger.warn((Object)"The date of last Processing process cannot be written to file.");
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exp) {
                this.logger.error((Object)("File " + filename + " cannot be closed due to " + exp.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressYear(String lastProcessing) {
        this.compressMonth(lastProcessing);
        this.compressDay(lastProcessing);
        this.compressHour(lastProcessing);
        String[] lastProcessingParts = lastProcessing.split("-");
        String yearPath = (String)LiveOptions.options.get((Object)"publishDiffRepoPath") + "/" + lastProcessingParts[0];
        String tarOutputFilename = lastProcessingParts[0] + ".tar";
        tarOutputFilename = (String)LiveOptions.options.get((Object)"publishDiffRepoPath") + "/" + tarOutputFilename;
        TarOutputStream osTarYear = null;
        try {
            osTarYear = new TarOutputStream((OutputStream)new FileOutputStream(new File(tarOutputFilename)));
            PublishedDataCompressor.convertToTar(new File(yearPath), osTarYear);
            this.compressFileUsingGZip(tarOutputFilename);
        }
        catch (IOException exp) {
            this.logger.error((Object)("TAR output file for " + yearPath + " cannot be created. Compression process cannot continue"));
        }
        finally {
            try {
                if (osTarYear != null) {
                    osTarYear.close();
                }
            }
            catch (IOException exp) {
                this.logger.error((Object)exp.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressMonth(String lastProcessing) {
        this.compressDay(lastProcessing);
        this.compressHour(lastProcessing);
        String[] lastProcessingParts = lastProcessing.split("-");
        String monthPath = (String)LiveOptions.options.get((Object)"publishDiffRepoPath") + "/" + lastProcessingParts[0] + "/" + lastProcessingParts[1];
        String tarOutputFilename = lastProcessingParts[0] + "-" + lastProcessingParts[1] + ".tar";
        tarOutputFilename = (String)LiveOptions.options.get((Object)"publishDiffRepoPath") + "/" + lastProcessingParts[0] + "/" + tarOutputFilename;
        TarOutputStream osTarMonth = null;
        try {
            osTarMonth = new TarOutputStream((OutputStream)new FileOutputStream(new File(tarOutputFilename)));
            PublishedDataCompressor.convertToTar(new File(monthPath), osTarMonth);
            osTarMonth.close();
            this.compressFileUsingGZip(tarOutputFilename);
        }
        catch (IOException exp) {
            this.logger.error((Object)("TAR output file for " + monthPath + " cannot be created. Compression process cannot continue"));
        }
        finally {
            try {
                if (osTarMonth != null) {
                    osTarMonth.close();
                }
            }
            catch (IOException exp) {
                this.logger.error((Object)exp.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressDay(String lastProcessing) {
        this.compressHour(lastProcessing);
        String[] lastProcessingParts = lastProcessing.split("-");
        String dayPath = (String)LiveOptions.options.get((Object)"publishDiffRepoPath") + "/" + lastProcessingParts[0] + "/" + lastProcessingParts[1] + "/" + lastProcessingParts[2];
        String tarOutputFilename = lastProcessingParts[0] + "-" + lastProcessingParts[1] + "-" + lastProcessingParts[2] + ".tar";
        tarOutputFilename = (String)LiveOptions.options.get((Object)"publishDiffRepoPath") + "/" + lastProcessingParts[0] + "/" + lastProcessingParts[1] + "/" + tarOutputFilename;
        TarOutputStream osTarDay = null;
        try {
            osTarDay = new TarOutputStream((OutputStream)new FileOutputStream(new File(tarOutputFilename)));
            PublishedDataCompressor.convertToTar(new File(dayPath), osTarDay);
            osTarDay.close();
            this.compressFileUsingGZip(tarOutputFilename);
        }
        catch (IOException exp) {
            this.logger.error((Object)("TAR output file for " + dayPath + " cannot be created. Compression process cannot continue"));
        }
        finally {
            try {
                if (osTarDay != null) {
                    osTarDay.close();
                }
            }
            catch (IOException exp) {
                this.logger.error((Object)exp.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressHour(String lastProcessing) {
        String[] lastProcessingParts = lastProcessing.split("-");
        String hourPath = (String)LiveOptions.options.get((Object)"publishDiffRepoPath") + "/" + lastProcessingParts[0] + "/" + lastProcessingParts[1] + "/" + lastProcessingParts[2] + "/" + lastProcessingParts[3];
        String tarOutputFilename = lastProcessingParts[0] + "-" + lastProcessingParts[1] + "-" + lastProcessingParts[2] + "-" + lastProcessingParts[3] + ".tar";
        tarOutputFilename = (String)LiveOptions.options.get((Object)"publishDiffRepoPath") + "/" + lastProcessingParts[0] + "/" + lastProcessingParts[1] + "/" + lastProcessingParts[2] + "/" + tarOutputFilename;
        TarOutputStream osTarHour = null;
        try {
            osTarHour = new TarOutputStream((OutputStream)new FileOutputStream(new File(tarOutputFilename)));
            PublishedDataCompressor.convertToTar(new File(hourPath), osTarHour);
            osTarHour.close();
            this.compressFileUsingGZip(tarOutputFilename);
        }
        catch (IOException exp) {
            this.logger.error((Object)("TAR output file for " + hourPath + " cannot be created. Compression process cannot continue"));
        }
        finally {
            try {
                if (osTarHour != null) {
                    osTarHour.close();
                }
            }
            catch (IOException exp) {
                this.logger.error((Object)exp.getMessage());
            }
        }
    }

    private static void convertToTar(File dir, TarOutputStream tos) throws IOException {
        File[] flist = dir.listFiles();
        int buffersize = 1024;
        byte[] buf = new byte[buffersize];
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                PublishedDataCompressor.convertToTar(flist[i], tos);
                continue;
            }
            String abs = dir.getAbsolutePath();
            String fabs = flist[i].getAbsolutePath();
            if (fabs.startsWith(abs)) {
                fabs = fabs.substring(abs.length());
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(flist[i]);
                TarEntry te = new TarEntry(fabs);
                te.setSize(flist[i].length());
                tos.setLongFileMode(2);
                tos.putNextEntry(te);
                int count = 0;
                while ((count = fis.read(buf, 0, buffersize)) != -1) {
                    tos.write(buf, 0, count);
                }
                continue;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (tos != null) {
                    tos.closeEntry();
                }
                if (fis != null) {
                    fis.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressFileUsingGZip(String filename) {
        FileInputStream in = null;
        File outputFile = null;
        FileOutputStream osCompressedFinal = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(filename);
            outputFile = new File(filename + ".gz");
            osCompressedFinal = new FileOutputStream(outputFile);
            out = new GzipCompressorOutputStream((OutputStream)osCompressedFinal);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.flush();
            File tarFileToDelete = new File(filename);
            tarFileToDelete.delete();
        }
        catch (IOException exp) {
            this.logger.error((Object)("File: " + filename + " cannot be compressed"));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exp) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException exp) {}
        }
    }

    private class CompressionDate {
        private int _year;
        private int _month;
        private int _day;
        private int _hour;

        public int getYear() {
            return this._year;
        }

        public int getMonth() {
            return this._month;
        }

        public int getDay() {
            return this._day;
        }

        public int getHour() {
            return this._hour;
        }

        public CompressionDate(String requiredDate) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH");
            String[] requiredDateParts = requiredDate.split("-");
            this._year = Integer.parseInt(requiredDateParts[0]);
            this._month = Integer.parseInt(requiredDateParts[1]);
            this._day = Integer.parseInt(requiredDateParts[2]);
            this._hour = Integer.parseInt(requiredDateParts[3]);
        }

        public CompressionDate(Date requiredDate) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH");
            String[] requiredDateParts = dateFormatter.format(requiredDate).split("-");
            this._year = Integer.parseInt(requiredDateParts[0]);
            this._month = Integer.parseInt(requiredDateParts[1]);
            this._day = Integer.parseInt(requiredDateParts[2]);
            this._hour = Integer.parseInt(requiredDateParts[3]);
        }

        public String toString() {
            return "Year = " + this._year + ", Month = " + this._month + ", Day = " + this._day + ", Hour = " + this._hour;
        }
    }
}

