/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.processor;

import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.core.LiveOptions;
import org.dbpedia.extraction.live.extraction.LiveExtractionConfigLoader;
import org.dbpedia.extraction.live.queue.LiveQueue;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.queue.LiveQueuePriority;
import org.dbpedia.extraction.live.storage.JSONCache;

public class PageProcessor
extends Thread {
    private static Logger logger = Logger.getLogger(PageProcessor.class);
    private volatile boolean keepRunning = true;

    public PageProcessor(String name) {
        this.setName("PageProcessor_" + name);
    }

    public PageProcessor() {
        this("PageProcessor");
    }

    public void startProcessor() {
        if (this.keepRunning) {
            this.start();
        }
    }

    public void stopProcessor() {
        this.keepRunning = false;
    }

    private void processPage(LiveQueueItem item) {
        try {
            Boolean extracted = LiveExtractionConfigLoader.extractPage(item, (String)LiveOptions.options.get((Object)"localApiURL"), (String)LiveOptions.options.get((Object)"language"));
            if (!extracted.booleanValue()) {
                JSONCache.setErrorOnCache(item.getItemID(), -1);
            }
        }
        catch (Exception exp) {
            logger.error((Object)("Error in processing page number " + item.getItemID() + ", and the reason is " + exp.getMessage()), (Throwable)exp);
            JSONCache.setErrorOnCache(item.getItemID(), -2);
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                LiveQueueItem page = LiveQueue.take();
                if (page.getPriority() == LiveQueuePriority.MappingPriority) {
                    LiveExtractionConfigLoader.reload(page.getStatQueueAdd());
                }
                if (page.isDeleted()) {
                    JSONCache.deleteCacheItem(page.getItemID(), LiveExtractionConfigLoader.policies());
                    continue;
                }
                this.processPage(page);
            }
            catch (Exception exp) {
                logger.error((Object)"Failed to process page");
            }
        }
    }
}

