/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.main;

import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.core.LiveOptions;
import org.dbpedia.extraction.live.feeder.Feeder;
import org.dbpedia.extraction.live.feeder.OAIFeeder;
import org.dbpedia.extraction.live.feeder.OAIFeederMappings;
import org.dbpedia.extraction.live.feeder.UnmodifiedFeeder;
import org.dbpedia.extraction.live.processor.PageProcessor;
import org.dbpedia.extraction.live.publisher.DiffData;
import org.dbpedia.extraction.live.publisher.PublishedDataCompressor;
import org.dbpedia.extraction.live.publisher.Publisher;
import org.dbpedia.extraction.live.queue.LiveQueue;
import org.dbpedia.extraction.live.queue.LiveQueuePriority;
import org.dbpedia.extraction.live.statistics.Statistics;
import org.dbpedia.extraction.live.util.DateUtil;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.dbpedia.extraction.live.util.Files;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class);
    public static BlockingQueue<DiffData> publishingDataQueue = new LinkedBlockingDeque<DiffData>();
    private static volatile Statistics statistics = null;
    private static volatile List<Feeder> feeders = new ArrayList<Feeder>(5);
    private static volatile List<PageProcessor> processors = new ArrayList<PageProcessor>(10);

    public static void authenticate(final String username, final String password) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password.toCharArray());
            }
        });
    }

    public static void initLive() {
        feeders.add(new OAIFeederMappings("FeederMappings", LiveQueuePriority.MappingPriority, (String)LiveOptions.options.get((Object)"mappingsOAIUri"), (String)LiveOptions.options.get((Object)"mappingsBaseWikiUri"), (String)LiveOptions.options.get((Object)"mappingsOaiPrefix"), 2000L, 1000L, (String)LiveOptions.options.get((Object)"uploaded_dump_date"), (String)LiveOptions.options.get((Object)"working_directory")));
        feeders.add(new OAIFeeder("FeederLive", LiveQueuePriority.LivePriority, (String)LiveOptions.options.get((Object)"oaiUri"), (String)LiveOptions.options.get((Object)"baseWikiUri"), (String)LiveOptions.options.get((Object)"oaiPrefix"), 3000L, 1000L, (String)LiveOptions.options.get((Object)"uploaded_dump_date"), (String)LiveOptions.options.get((Object)"working_directory")));
        feeders.add(new UnmodifiedFeeder("FeederUnmodified", LiveQueuePriority.UnmodifiedPagePriority, 30, 5000, 500, 30000L, (String)LiveOptions.options.get((Object)"uploaded_dump_date"), (String)LiveOptions.options.get((Object)"working_directory")));
        int threads = Integer.parseInt((String)LiveOptions.options.get((Object)"ProcessingThreads"));
        for (int i = 0; i < threads; ++i) {
            processors.add(new PageProcessor("N" + (i + 1)));
        }
        statistics = new Statistics((String)LiveOptions.options.get((Object)"statisticsFilePath"), 20, DateUtil.getDuration1MinMillis(), 2L * DateUtil.getDuration1MinMillis());
    }

    public static void startLive() {
        try {
            for (Feeder f : feeders) {
                f.startFeeder();
            }
            for (PageProcessor p : processors) {
                p.startProcessor();
            }
            Publisher publisher = new Publisher("Publisher", 4);
            PublishedDataCompressor compressor = new PublishedDataCompressor("PublishedDataCompressor", 1);
            statistics.startStatistics();
            logger.info((Object)"DBpedia-Live components started");
        }
        catch (Exception exp) {
            logger.error((Object)ExceptionUtil.toString(exp));
            Main.stopLive();
        }
    }

    public static void stopLive() {
        try {
            logger.warn((Object)"Stopping DBpedia Live components");
            for (PageProcessor p : processors) {
                p.stopProcessor();
            }
            for (Feeder f : feeders) {
                f.stopFeeder(LiveQueue.getPriorityDate(f.getQueuePriority()));
            }
            if (statistics != null) {
                statistics.stopStatistics();
            }
        }
        catch (Exception exp) {
            logger.error((Object)ExceptionUtil.toString(exp));
        }
    }

    public static void main(String[] args) throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Main.stopLive();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Main.authenticate("dbpedia", Files.readFile(new File("pw.txt")).trim());
        Main.initLive();
        Main.startLive();
    }
}

