/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import java.util.Collections;
import java.util.List;
import org.dbpedia.extraction.live.feeder.Feeder;
import org.dbpedia.extraction.live.queue.LiveQueue;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.queue.LiveQueuePriority;
import org.dbpedia.extraction.live.storage.JDBCUtil;

public class UnmodifiedFeeder
extends Feeder {
    private int minDaysAgo = 0;
    private long chunk = 0L;
    private long threshold = 0L;
    private long sleepTime = 0L;

    public UnmodifiedFeeder(String feederName, LiveQueuePriority queuePriority, int minDaysAgo, int chunk, int threshold, long sleepTime, String defaultStartTime, String folderBasePath) {
        super(feederName, queuePriority, defaultStartTime, folderBasePath);
        this.minDaysAgo = minDaysAgo;
        this.chunk = chunk;
        this.threshold = threshold;
        this.sleepTime = sleepTime;
    }

    @Override
    public void startFeeder() {
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.startFeeder();
    }

    @Override
    protected List<LiveQueueItem> getNextItems() {
        while (LiveQueue.getQueueSize() > this.threshold) {
            try {
                int m = (int)(LiveQueue.getQueueSize() / this.threshold);
                Thread.sleep((long)m * this.sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        List<LiveQueueItem> items = JDBCUtil.getCacheUnmodified(this.minDaysAgo, this.chunk);
        if (items.size() == 0) {
            try {
                Thread.sleep(5L * this.sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
        return items;
    }
}

