/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections15.MultiMap;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.feeder.DBpediaQLUtil;
import org.dbpedia.extraction.live.feeder.MyVocabulary;
import org.dbpedia.extraction.live.util.sparql.ISparulExecutor;

class TBoxTripleDestination {
    private static Logger logger = Logger.getLogger(TBoxTripleDestination.class);
    private String reifierPrefix;
    private String dataGraphName;
    private String metaGraphName;
    private ISparulExecutor executor;
    private MessageDigest md5;
    private static Resource origin = ResourceFactory.createResource((String)"http://dbpedia.org/meta/TBoxExtractor");

    public TBoxTripleDestination(ISparulExecutor executor, String dataGraphName, String metaGraphName, String refifierPrefix) throws NoSuchAlgorithmException {
        this.executor = executor;
        this.dataGraphName = dataGraphName;
        this.metaGraphName = metaGraphName;
        this.reifierPrefix = refifierPrefix;
        this.md5 = MessageDigest.getInstance("MD5");
    }

    private void deleteFromMetaGraphBySourcePage(Resource sourcePage) throws Exception {
        String query = DBpediaQLUtil.deleteMetaBySourcePage(sourcePage.toString(), this.metaGraphName);
        logger.debug((Object)"Running query: 'deleteFromMetaGraphBySourcePage'");
        this.executor.executeUpdate(query);
    }

    private void deleteFromDataGraphBySourcePage(Resource sourcePage) throws Exception {
        String query = DBpediaQLUtil.deleteDataBySourcePage(sourcePage.toString(), this.dataGraphName, this.metaGraphName);
        logger.debug((Object)"Running query: 'deleteFromDataGraphBySourcePage'");
        this.executor.executeUpdate(query);
    }

    private void deleteFromDataGraph(Resource oaiId) throws Exception {
        String query = "Delete From <" + this.dataGraphName + ">\n" + "{\n" + "?s ?p ?o\n" + "}\n" + "{\n" + "Graph <" + this.dataGraphName + "> {\n" + "?a <" + MyVocabulary.DBM_OAIIDENTIFIER + "> <" + oaiId + ">\n" + "}\n" + "Graph <" + this.metaGraphName + "> {\n" + "?b <" + MyVocabulary.DBM_SOURCE_PAGE + "> ?a .\n" + "?b <" + MyVocabulary.OWL_ANNOTATED_SOURCE + "> ?s .\n" + "?b <" + MyVocabulary.OWL_ANNOTATED_PROPERTY + "> ?p .\n" + "?b <" + MyVocabulary.OWL_ANNOTATED_TARGET + "> ?o .\n" + "}\n" + "}\n";
        logger.debug((Object)"Running query: 'deleteFromDataGraph'");
        this.executor.executeUpdate(query);
    }

    private void deleteFromMetaGraph(Resource oaiId) throws Exception {
        String query = "Delete From <" + this.metaGraphName + ">\n" + "{\n" + "?b ?x ?y\n" + "}\n" + "From <" + this.metaGraphName + "> \n" + "{\n" + "?t <" + MyVocabulary.OWL_ANNOTATED_PROPERTY + "> <" + MyVocabulary.DBM_OAIIDENTIFIER + "> .\n" + "?t <" + MyVocabulary.OWL_ANNOTATED_TARGET + "> <" + oaiId + "> .\n" + "?t <" + MyVocabulary.DBM_SOURCE_PAGE + "> ?a .\n" + "?b <" + MyVocabulary.DBM_SOURCE_PAGE + "> ?a .\n" + "?b ?x ?y .\n" + "}\n";
        logger.debug((Object)"Running query: 'deleteFromMetaGraph'");
        this.executor.executeUpdate(query);
    }

    private Model reify(Model result, Statement triple, Resource reifier) {
        result.add(reifier, MyVocabulary.OWL_ANNOTATED_SOURCE, (RDFNode)triple.getSubject());
        result.add(reifier, MyVocabulary.OWL_ANNOTATED_PROPERTY, (RDFNode)triple.getPredicate());
        result.add(reifier, MyVocabulary.OWL_ANNOTATED_TARGET, triple.getObject());
        return result;
    }

    private void insertIntoDataGraph(Resource rootId, Resource sourcePage, MultiMap<Resource, Model> triples) throws Exception {
        Model inserts = ModelFactory.createDefaultModel();
        for (Map.Entry item : triples.entrySet()) {
            for (Model tmp : (Collection)item.getValue()) {
                inserts.add(tmp);
            }
        }
        logger.debug((Object)"Running query: 'insertIntoDataGraph'");
        this.executor.insert(inserts, this.dataGraphName);
    }

    private Resource generateMD5HashUri(String pageId, Statement triple) {
        return ResourceFactory.createResource((String)(this.reifierPrefix + pageId + "_" + this.generateMD5(triple)));
    }

    private String generateMD5(Statement triple) {
        String str = triple.getSubject().toString() + " " + triple.getPredicate().toString() + " " + triple.getObject().toString();
        return this.generateMD5(str);
    }

    private String generateMD5(String str) {
        this.md5.reset();
        this.md5.update(str.getBytes());
        byte[] result = this.md5.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & result[i]));
        }
        return hexString.toString();
    }

    private void insertIntoMetaGraph(Resource rootIRI, Resource sourcePage, String pageId, MultiMap<Resource, Model> triples) throws Exception {
        Model inserts = ModelFactory.createDefaultModel();
        for (Map.Entry item : triples.entrySet()) {
            Resource aspect = (Resource)item.getKey();
            for (Model tmp : (Collection)item.getValue()) {
                for (Statement triple : tmp.listStatements().toSet()) {
                    Resource reifier = this.generateMD5HashUri(pageId, triple);
                    this.reify(inserts, triple, reifier);
                    inserts.add(reifier, MyVocabulary.DBM_SOURCE_PAGE, (RDFNode)rootIRI);
                    inserts.add(reifier, MyVocabulary.DBM_ORIGIN, (RDFNode)origin);
                    if (aspect == null) continue;
                    inserts.add(reifier, MyVocabulary.DBM_ASPECT, (RDFNode)aspect);
                }
            }
        }
        logger.debug((Object)"Running query: 'insertIntoMetaGraph'");
        this.executor.insert(inserts, this.metaGraphName);
    }

    public void delete(Resource oaiId) throws Exception {
        this.deleteFromDataGraph(oaiId);
        this.deleteFromMetaGraph(oaiId);
    }

    public void update(Resource rootIRI, Resource sourcePage, Resource oaiId, String pageId, MultiMap<Resource, Model> triples) throws Exception {
        this.deleteFromDataGraphBySourcePage(rootIRI);
        this.deleteFromMetaGraphBySourcePage(rootIRI);
        if (triples != null) {
            this.insertIntoMetaGraph(rootIRI, sourcePage, pageId, triples);
            this.insertIntoDataGraph(rootIRI, sourcePage, triples);
        }
    }
}

