/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.DCTerms;
import java.net.URI;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.feeder.MyVocabulary;
import org.dbpedia.extraction.live.feeder.TBoxTripleDestination;
import org.dbpedia.extraction.live.feeder.TBoxTripleGenerator;
import org.dbpedia.extraction.live.util.StringUtil;
import org.dbpedia.extraction.sources.Source;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.Namespace$;
import org.dbpedia.extraction.wikiparser.PageNode;
import org.dbpedia.extraction.wikiparser.WikiTitle;
import org.dbpedia.extraction.wikiparser.impl.simple.SimpleWikiParser;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterable$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Traversable$;
import scala.collection.mutable.MultiMap;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u00015\u0011a\u0002\u0016\"pq\u0016CHO]1di>\u0014(G\u0003\u0002\u0004\t\u00051a-Z3eKJT!!\u0002\u0004\u0002\t1Lg/\u001a\u0006\u0003\u000f!\t!\"\u001a=ue\u0006\u001cG/[8o\u0015\tI!\"A\u0004eEB,G-[1\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!b\u0001\n\u00031\u0012!\u00049sK\u001aL\u00070T1qa&tw-F\u0001\u0018!\tA2%D\u0001\u001a\u0015\tQ2$\u0001\u0004tQ\u0006\u0014X\r\u001a\u0006\u00039u\tAA[3oC*\u0011adH\u0001\u0004QBd'B\u0001\u0011\"\u0003\tA\u0007OC\u0001#\u0003\r\u0019w.\\\u0005\u0003Ie\u0011Q\u0002\u0015:fM&DX*\u00199qS:<\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\u001dA\u0014XMZ5y\u001b\u0006\u0004\b/\u001b8hA!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011&A\u0004cCN,WK]5\u0016\u0003)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\t1\fgn\u001a\u0006\u0002_\u0005!!.\u0019<b\u0013\t\tDF\u0001\u0004TiJLgn\u001a\u0005\tg\u0001\u0011\t\u0011)A\u0005U\u0005A!-Y:f+JL\u0007\u0005\u0003\u00056\u0001\t\u0015\r\u0011\"\u0001*\u0003)\u0011xn\u001c;Qe\u00164\u0017\u000e\u001f\u0005\to\u0001\u0011\t\u0011)A\u0005U\u0005Y!o\\8u!J,g-\u001b=!\u0011!I\u0004A!b\u0001\n\u0003I\u0013aC5o]\u0016\u0014\bK]3gSbD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006IAK\u0001\rS:tWM\u001d)sK\u001aL\u0007\u0010\t\u0005\t{\u0001\u0011)\u0019!C\u0001}\u0005YA-Z:uS:\fG/[8o+\u0005y\u0004C\u0001!B\u001b\u0005\u0011\u0011B\u0001\"\u0003\u0005U!&i\u001c=Ue&\u0004H.\u001a#fgRLg.\u0019;j_:D\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006IaP\u0001\rI\u0016\u001cH/\u001b8bi&|g\u000e\t\u0005\u0006\r\u0002!\taR\u0001\u0007y%t\u0017\u000e\u001e \u0015\r!K%j\u0013'N!\t\u0001\u0005\u0001C\u0003\u0016\u000b\u0002\u0007q\u0003C\u0003)\u000b\u0002\u0007!\u0006C\u00036\u000b\u0002\u0007!\u0006C\u0003:\u000b\u0002\u0007!\u0006C\u0003>\u000b\u0002\u0007q\bC\u0003P\u0001\u0011\u0005\u0001+A\bue&\u0004H.Z$f]\u0016\u0014\u0018\r^8s+\u0005\t\u0006C\u0001!S\u0013\t\u0019&AA\nU\u0005>DHK]5qY\u0016<UM\\3sCR|'\u000fC\u0004V\u0001\t\u0007IQ\u0002,\u0002\r1|wmZ3s+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0015awn\u001a\u001bk\u0015\ta&\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003=f\u0013a\u0001T8hO\u0016\u0014\bB\u00021\u0001A\u00035q+A\u0004m_\u001e<WM\u001d\u0011\t\u000f\t\u0004!\u0019!C\u0007S\u0005\trJ\u0014+P\u0019>;\u0015l\u0018)S\u001fB+%\u000bV-\t\r\u0011\u0004\u0001\u0015!\u0004+\u0003Iye\nV(M\u001f\u001eKv\f\u0015*P!\u0016\u0013F+\u0017\u0011\t\u000f\u0019\u0004!\u0019!C\u0007S\u0005qqJ\u0014+P\u0019>;\u0015lX\"M\u0003N\u001b\u0006B\u00025\u0001A\u00035!&A\bP\u001dR{EjT$Z?\u000ec\u0015iU*!\u0011\u001dQ\u0007\u00011A\u0005\n-\fQ\"\\1y\u001dVlGK]5qY\u0016\u001cX#\u00017\u0011\u0005=i\u0017B\u00018\u0011\u0005\rIe\u000e\u001e\u0005\ba\u0002\u0001\r\u0011\"\u0003r\u0003Ei\u0017\r\u001f(v[R\u0013\u0018\u000e\u001d7fg~#S-\u001d\u000b\u0003eV\u0004\"aD:\n\u0005Q\u0004\"\u0001B+oSRDqA^8\u0002\u0002\u0003\u0007A.A\u0002yIEBa\u0001\u001f\u0001!B\u0013a\u0017AD7bq:+X\u000e\u0016:ja2,7\u000f\t\u0005\bu\u0002\u0011\r\u0011\"\u0002|\u00031)\u0007\u0010\u001e:bGR|'/\u0016:j+\u0005a\bcA?\u0002\u00025\taP\u0003\u0002\u0000]\u0005\u0019a.\u001a;\n\u0007\u0005\raPA\u0002V%&Cq!a\u0002\u0001A\u00035A0A\u0007fqR\u0014\u0018m\u0019;peV\u0013\u0018\u000e\t\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003-9W\r\u001e*p_Rt\u0015-\\3\u0015\u0007)\ny\u0001\u0003\u0005\u0002\u0012\u0005%\u0001\u0019AA\n\u0003\u0015!\u0018\u000e\u001e7f!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r\r\u0005Qq/[6ja\u0006\u00148/\u001a:\n\t\u0005u\u0011q\u0003\u0002\n/&\\\u0017\u000eV5uY\u0016Dq!!\t\u0001\t\u0003\t\u0019#\u0001\u0007d_VtG\u000f\u0016:ja2,7\u000fF\u0002m\u0003KA\u0001\"a\n\u0002 \u0001\u0007\u0011\u0011F\u0001\u0005I\u0006$\u0018\r\u0005\u0005\u0002,\u0005U\u0012\u0011HA%\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003g\u0001\u0012AC2pY2,7\r^5p]&!\u0011qGA\u0017\u0005!iU\u000f\u001c;j\u001b\u0006\u0004\b\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0006[>$W\r\u001c\u0006\u0004\u0003\u0007Z\u0012a\u0001:eM&!\u0011qIA\u001f\u0005!\u0011Vm]8ve\u000e,\u0007\u0003BA\u001e\u0003\u0017JA!!\u0014\u0002>\t)Qj\u001c3fY\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013A\u00025b]\u0012dW\rF\u0002s\u0003+B\u0001\"a\u0016\u0002P\u0001\u0007\u0011\u0011L\u0001\u0007g>,(oY3\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018\u0007\u0003\u001d\u0019x.\u001e:dKNLA!a\u0019\u0002^\t11k\\;sG\u0016Dq!!\u0015\u0001\t\u0003\t9\u0007F\u0002s\u0003SB\u0001\"a\u001b\u0002f\u0001\u0007\u0011QN\u0001\u000fa\u0006<WMT8eKN{WO]2f!\u0019\ty'a \u0002\u0006:!\u0011\u0011OA>\u001d\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$bAA<\u0019\u00051AH]8pizJ\u0011!E\u0005\u0004\u0003{\u0002\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\u000b\u0019IA\u0006Ue\u00064XM]:bE2,'bAA?!A!\u0011QCAD\u0013\u0011\tI)a\u0006\u0003\u0011A\u000bw-\u001a(pI\u0016Dq!!\u0015\u0001\t\u0003\ti\tF\u0002s\u0003\u001fC\u0001\"!%\u0002\f\u0002\u0007\u0011QQ\u0001\ta\u0006<WMT8eK\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0015A\u00023fY\u0016$X\rF\u0002s\u00033C\u0001\"a'\u0002\u0014\u0002\u0007\u0011\u0011H\u0001\u0006_\u0006L\u0017\n\u001a")
public class TBoxExtractor2 {
    private final PrefixMapping prefixMapping;
    private final String baseUri;
    private final String rootPrefix;
    private final String innerPrefix;
    private final TBoxTripleDestination destination;
    private final Logger logger;
    private final String ONTOLOGY_PROPERTY;
    private final String ONTOLOGY_CLASS;
    private int maxNumTriples;
    private final URI extractorUri;

    public PrefixMapping prefixMapping() {
        return this.prefixMapping;
    }

    public String baseUri() {
        return this.baseUri;
    }

    public String rootPrefix() {
        return this.rootPrefix;
    }

    public String innerPrefix() {
        return this.innerPrefix;
    }

    public TBoxTripleDestination destination() {
        return this.destination;
    }

    public TBoxTripleGenerator tripleGenerator() {
        return new TBoxTripleGenerator(this.prefixMapping());
    }

    private final Logger logger() {
        return this.logger;
    }

    private final String ONTOLOGY_PROPERTY() {
        return this.ONTOLOGY_PROPERTY;
    }

    private final String ONTOLOGY_CLASS() {
        return this.ONTOLOGY_CLASS;
    }

    private int maxNumTriples() {
        return this.maxNumTriples;
    }

    private void maxNumTriples_$eq(int x$1) {
        this.maxNumTriples = x$1;
    }

    public final URI extractorUri() {
        return this.extractorUri;
    }

    public String getRootName(WikiTitle title) {
        block4: {
            String suffix;
            String prefix;
            String rootName;
            block3: {
                block2: {
                    rootName = "error";
                    String[] parts = title.encoded().split(":", 2);
                    prefix = parts.length == 1 ? "" : new StringBuilder().append((Object)StringUtil.lcFirst(parts[0])).append((Object)":").toString();
                    suffix = parts.length == 1 ? parts[0] : parts[1];
                    Namespace namespace = title.namespace();
                    Namespace namespace2 = Namespace$.MODULE$.OntologyClass();
                    if (namespace != null ? !namespace.equals(namespace2) : namespace2 != null) break block2;
                    suffix = StringUtil.ucFirst(suffix);
                    break block3;
                }
                Namespace namespace = title.namespace();
                Namespace namespace3 = Namespace$.MODULE$.OntologyProperty();
                if (namespace != null ? !namespace.equals(namespace3) : namespace3 != null) break block4;
                suffix = StringUtil.lcFirst(suffix);
            }
            rootName = new StringBuilder().append((Object)prefix).append((Object)suffix).toString();
            return rootName;
        }
        this.logger().error((Object)new StringBuilder().append((Object)"Unexpected title: ").append((Object)title).toString());
        return null;
    }

    public int countTriples(MultiMap<Resource, Model> data) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)data.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Set<Model> x$1) {
                return x$1.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void handle(Source source) {
        this.handle((Traversable<PageNode>)((Traversable)source.map((Function1)new SimpleWikiParser(), Traversable$.MODULE$.canBuildFrom())));
    }

    public void handle(Traversable<PageNode> pageNodeSource) {
        pageNodeSource.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TBoxExtractor2 $outer;

            public final void apply(PageNode pageNode) {
                this.$outer.handle(pageNode);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void handle(PageNode pageNode) {
        void var3_3;
        String rootName = this.getRootName(pageNode.title());
        if (rootName == null) {
            return;
        }
        Resource rootId = ResourceFactory.createResource((String)this.prefixMapping().expandPrefix(rootName));
        if (rootId.toString().startsWith("http://")) {
            BoxedUnit boxedUnit;
            this.tripleGenerator().exprPrefixRef().setValue(new StringBuilder().append((Object)rootId.toString()).append((Object)"/").toString());
            MultiMap<Resource, Model> result = this.tripleGenerator().load(rootId, pageNode);
            int numTriples = this.countTriples(result);
            if (numTriples == 0) {
                return;
            }
            Model model = ModelFactory.createDefaultModel();
            if (this.maxNumTriples() > 0 && numTriples > this.maxNumTriples()) {
                result.clear();
                boxedUnit = model.add(rootId, MyVocabulary.DBM_ERROR, (RDFNode)ResourceFactory.createPlainLiteral((String)new StringBuilder().append(numTriples).append((Object)" generated triples exceeded the ").append((Object)BoxesRunTime.boxToInteger((int)this.maxNumTriples())).append((Object)" triple limit.").toString()));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Resource revisionLink = ResourceFactory.createResource((String)new StringBuilder().append((Object)this.baseUri()).append((Object)"index.php?title=").append((Object)pageNode.title().encodedWithNamespace()).append((Object)"&oldid=").append((Object)BoxesRunTime.boxToLong((long)pageNode.revision())).toString());
            Resource editLink = ResourceFactory.createResource((String)new StringBuilder().append((Object)this.baseUri()).append((Object)"index.php?title=").append((Object)pageNode.title().encodedWithNamespace()).append((Object)"&action=edit").toString());
            model.add(rootId, MyVocabulary.DBM_REVISION, (RDFNode)revisionLink);
            model.add(rootId, MyVocabulary.DBM_EDIT_LINK, (RDFNode)editLink);
            GregorianCalendar now = new GregorianCalendar();
            model.add(rootId, DCTerms.modified, (RDFNode)model.createTypedLiteral((Object)now));
            Resource oaiId = ResourceFactory.createResource((String)"oai:en:wikipedia:org:");
            result.addBinding(null, (Object)model);
            this.destination().update(rootId, rootId, oaiId, String.valueOf(BoxesRunTime.boxToLong((long)pageNode.id())), this.tripleGenerator().toJava(result));
            return;
        }
        this.logger().warn((Object)new StringBuilder().append((Object)"Skipping resource ").append((Object)var3_3).append((Object)" because it does not start with http://").toString());
    }

    public void delete(Resource oaiId) {
        try {
            this.destination().delete(oaiId);
        }
        catch (Exception exception) {
            this.logger().error((Object)"Something went wrong", (Throwable)exception);
        }
    }

    public TBoxExtractor2(PrefixMapping prefixMapping, String baseUri, String rootPrefix, String innerPrefix, TBoxTripleDestination destination) {
        this.prefixMapping = prefixMapping;
        this.baseUri = baseUri;
        this.rootPrefix = rootPrefix;
        this.innerPrefix = innerPrefix;
        this.destination = destination;
        this.logger = Logger.getLogger(TBoxExtractor2.class);
        this.ONTOLOGY_PROPERTY = "OntologyProperty";
        this.ONTOLOGY_CLASS = "OntologyClass";
        this.maxNumTriples = 500;
        this.extractorUri = URI.create(new StringBuilder().append((Object)MyVocabulary.NS).append((Object)TBoxExtractor2.class.getSimpleName()).toString());
    }
}

