/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.jena_owlapi.Conversion;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.coode.owlapi.rdf.model.RDFGraph;
import org.coode.owlapi.rdf.model.RDFTranslator;
import org.dbpedia.extraction.live.feeder.ManchesterParse;
import org.dbpedia.extraction.live.feeder.RDFExpression;
import org.dbpedia.extraction.util.StringUtils;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class RDFUtil {
    private static Logger logger = Logger.getLogger(RDFUtil.class);
    private static MessageDigest md5 = null;

    public static URI generateMD5HashUri(String prefix, Statement triple) {
        return URI.create(prefix + RDFUtil.generateMD5(triple));
    }

    public static String generateMD5(Statement triple) {
        String str = triple.getSubject().toString() + " " + triple.getPredicate().toString() + " " + triple.getObject().toString();
        return RDFUtil.generateMD5(str);
    }

    public static String generateMD5(String str) {
        md5.reset();
        md5.update(str.getBytes());
        byte[] result = md5.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & result[i]));
        }
        return hexString.toString();
    }

    private static Model stripTypeClass(Model result) {
        result.remove(result.listStatements(null, RDF.type, (RDFNode)OWL.Class).toList());
        return result;
    }

    public static RDFExpression interpretMos(String text, PrefixMapping prefixResolver, String innerPrefix, boolean generateTypeClass) throws Exception {
        RDFExpression e = RDFUtil.parseManchesterOWLClassExpression(text, prefixResolver, generateTypeClass);
        Map<RDFNode, Resource> map = RDFUtil.relabelBlankNodes(e.getTriples(), innerPrefix);
        RDFUtil.resolve((RDFNode)e.getRootSubject(), prefixResolver, map);
        map.putAll(RDFUtil.resolve(e.getTriples(), prefixResolver));
        Model triples = RDFUtil.relableStatements(e.getTriples(), map);
        Resource rootNode = map.get(e.getRootSubject());
        if (rootNode == null) {
            rootNode = e.getRootSubject();
        }
        RDFExpression result = rootNode == null ? null : new RDFExpression(rootNode, triples);
        String msg = "Statements generated for MOS-Expression '" + text + "':\n";
        if (result == null) {
            logger.trace((Object)(msg + "None"));
        } else {
            msg = msg + "\tRoot subject = " + rootNode + "\n";
            for (Statement item : triples.listStatements().toSet()) {
                msg = msg + "\t" + item.toString() + "\n";
            }
            logger.trace((Object)msg);
        }
        return result;
    }

    private static Map<RDFNode, Resource> resolve(Model triples, PrefixMapping resolver) throws UnsupportedEncodingException {
        HashMap<RDFNode, Resource> result = new HashMap<RDFNode, Resource>();
        for (Statement triple : triples.listStatements().toSet()) {
            RDFUtil.resolve(triple, resolver, result);
        }
        return result;
    }

    private static void resolve(Statement triple, PrefixMapping resolver, Map<RDFNode, Resource> map) throws UnsupportedEncodingException {
        RDFUtil.resolve((RDFNode)triple.getSubject(), resolver, map);
        RDFUtil.resolve((RDFNode)triple.getPredicate(), resolver, map);
        RDFUtil.resolve(triple.getObject(), resolver, map);
    }

    private static void resolve(RDFNode node, PrefixMapping resolver, Map<RDFNode, Resource> map) throws UnsupportedEncodingException {
        if (node.isAnon() || node.isLiteral()) {
            return;
        }
        String value = node.toString();
        if (!value.startsWith("http://relabel.me/")) {
            return;
        }
        String expanded = resolver.expandPrefix(value = value.substring("http://relabel.me/".length()));
        Resource uri = ResourceFactory.createResource((String)expanded);
        if (uri == null) {
            throw new RuntimeException("'" + value + "' didn't resolve to an uri.");
        }
        Resource mapped = map.get(node);
        if (mapped == null) {
            map.put(node, uri);
        }
    }

    private static Model resolve2(Model triples, Transformer<String, Resource> resolver) {
        Model result = ModelFactory.createDefaultModel();
        for (Statement triple : triples.listStatements().toSet()) {
            result.add(RDFUtil.resolve2(triple, resolver));
        }
        return result;
    }

    private static Statement resolve2(Statement triple, Transformer<String, Resource> resolver) {
        Resource s = (Resource)RDFUtil.resolve2((RDFNode)triple.getSubject(), resolver);
        Property p = (Property)RDFUtil.resolve2((RDFNode)triple.getPredicate(), resolver);
        RDFNode o = RDFUtil.resolve2(triple.getObject(), resolver);
        if (triple.getSubject() == s && triple.getPredicate() == p && triple.getObject() == o) {
            return triple;
        }
        return new StatementImpl(s, p, o);
    }

    private static RDFNode resolve2(RDFNode node, Transformer<String, Resource> resolver) {
        if (node.isAnon() || node.isLiteral()) {
            return node;
        }
        String value = node.toString();
        if (!value.startsWith("http://relabel.me/")) {
            return node;
        }
        Resource uri = (Resource)resolver.transform((Object)(value = value.substring("http://relabel.me/".length())));
        if (uri == null) {
            throw new NullPointerException();
        }
        return uri;
    }

    public static Set<Resource> findRoots(Model model) {
        Set result = model.listSubjects().toSet();
        result.removeAll(model.listObjects().toSet());
        return result;
    }

    private static RDFExpression parseManchesterOWLClassExpression(String text, PrefixMapping prefixResolver, boolean generateTypeClass) throws Exception {
        String base = "http://relabel.me/";
        OWLOntologyManager m = OWLManager.createOWLOntologyManager();
        OWLOntology o = m.createOntology(IRI.create((String)"http://this_should_not_show_up_anywhere.org"));
        OWLClassExpression classExpression = ManchesterParse.parse(text, base, prefixResolver);
        RDFTranslator t = new RDFTranslator(m, o, false);
        classExpression.accept((OWLObjectVisitor)t);
        RDFGraph rdfGraph = t.getGraph();
        String str = Conversion.toStringNTriples((RDFGraph)rdfGraph);
        Model result = ModelFactory.createDefaultModel();
        logger.info((Object)"-----");
        logger.info((Object)str);
        logger.info((Object)"-----");
        result.read((InputStream)new ByteArrayInputStream(str.getBytes()), null, "N-TRIPLE");
        Set<Resource> rootNodes = RDFUtil.findRoots(result);
        Resource rootSubject = null;
        if (rootNodes.size() == 0) {
            rootSubject = ResourceFactory.createResource((String)prefixResolver.expandPrefix(text.trim()));
        } else if (rootNodes.size() == 1) {
            rootSubject = rootNodes.iterator().next();
        } else {
            throw new RuntimeException("Unexpected multiple root nodes");
        }
        if (!generateTypeClass) {
            result = RDFUtil.stripTypeClass(result);
        }
        return new RDFExpression(rootSubject, result);
    }

    public static Model relableStatements(Model model, Map<RDFNode, Resource> map) {
        Model result = ModelFactory.createDefaultModel();
        for (Statement triple : model.listStatements().toSet()) {
            result.add(RDFUtil.relableStatement(triple, map));
        }
        return result;
    }

    public static Statement relableStatement(Statement triple, Map<RDFNode, Resource> map) {
        RDFNode o;
        Property p;
        boolean changed = false;
        Resource s = map.get(triple.getSubject());
        if (s == null) {
            s = triple.getSubject();
            changed = true;
        }
        if ((p = (Property)map.get(triple.getPredicate())) == null) {
            p = triple.getPredicate();
            changed = true;
        }
        if ((o = (RDFNode)map.get(triple.getObject())) == null) {
            o = triple.getObject();
            changed = true;
        }
        if (changed) {
            return new StatementImpl(s, p, o);
        }
        return triple;
    }

    public static Map<RDFNode, Resource> relabelBlankNodes(Model triples, String prefix) {
        HashMap<RDFNode, Resource> result = new HashMap<RDFNode, Resource>();
        if (prefix == null) {
            return result;
        }
        for (Statement triple : triples.listStatements().toSet()) {
            RDFUtil.relabelBlankNode((RDFNode)triple.getSubject(), prefix, result);
            RDFUtil.relabelBlankNode((RDFNode)triple.getPredicate(), prefix, result);
            RDFUtil.relabelBlankNode(triple.getObject(), prefix, result);
        }
        return result;
    }

    public static Resource relabelBlankNode(RDFNode node, String prefix, Map<RDFNode, Resource> oldToNew) {
        if (!node.isAnon()) {
            return null;
        }
        String id = StringUtils.md5sum((String)node.toString());
        Resource newId = oldToNew.get(id);
        if (newId == null) {
            newId = ResourceFactory.createResource((String)(prefix + id));
            oldToNew.put(node, newId);
        }
        return newId;
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            logger.fatal((Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw new RuntimeException(e);
        }
    }
}

