/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.PropertyConfigurator;
import org.dbpedia.extraction.live.feeder.OntologyUpdateFeederConfig;
import org.dbpedia.extraction.live.feeder.PrefixMappingBase;
import org.dbpedia.extraction.live.feeder.TBoxExtractor2;
import org.dbpedia.extraction.live.feeder.TBoxTripleDestination;
import org.dbpedia.extraction.live.util.DBPediaXPathUtil;
import org.dbpedia.extraction.live.util.Files;
import org.dbpedia.extraction.live.util.LastResponseDateManager;
import org.dbpedia.extraction.live.util.OAIUtil;
import org.dbpedia.extraction.live.util.XMLUtil;
import org.dbpedia.extraction.live.util.XPathUtil;
import org.dbpedia.extraction.live.util.sparql.VirtuosoJdbcSparulExecutor;
import org.dbpedia.extraction.ontology.io.OntologyReader;
import org.dbpedia.extraction.sources.Source;
import org.dbpedia.extraction.sources.XMLSource;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML;
import virtuoso.jdbc4.VirtuosoDataSource;

public class OntologyUpdateFeeder
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(OntologyUpdateFeeder.class);
    private Iterator<Document> recordIterator;
    private TBoxExtractor2 extractor;
    private File lastResponseDateFile;

    public static void main(String[] args) throws Exception {
        String startDate;
        PropertyConfigurator.configure((String)"log4j.properties");
        Ini ini = new Ini(new File("cfg/mappings.dbpedia.org/config.ini"));
        OntologyUpdateFeederConfig config = new OntologyUpdateFeederConfig();
        ((Profile.Section)ini.get((Object)"HARVESTER")).to((Object)config);
        ((Profile.Section)ini.get((Object)"BACKEND_VIRTUOSO")).to((Object)config);
        ((Profile.Section)ini.get((Object)"PROPERTY_DEFINITION_EXTRACTOR")).to((Object)config);
        ((Profile.Section)ini.get((Object)"LOGGING")).to((Object)config);
        File lastResponseDateFile = new File("cfg/mappings.dbpedia.org/last-response-date.txt");
        String string = startDate = config.isStartNow() ? LastResponseDateManager.getNow() : LastResponseDateManager.getLastResponseDate(lastResponseDateFile);
        if (startDate == null) {
            startDate = "2009-01-01T15:00:00Z";
        }
        logger.info("Loading uri namespaces");
        Model prefixModel = ModelFactory.createDefaultModel();
        FileInputStream in = new FileInputStream(new File("cfg/mappings.dbpedia.org/prefixes.ttl"));
        prefixModel.read((InputStream)in, null, "TTL");
        ((InputStream)in).close();
        Map prefixMap = prefixModel.getNsPrefixMap();
        PrefixMappingImpl prefixMapping = new PrefixMappingImpl();
        prefixMapping.setNsPrefixes(prefixMap);
        PrefixMappingBase tmp = new PrefixMappingBase((PrefixMapping)prefixMapping, prefixModel.getNsPrefixURI("base"));
        VirtuosoDataSource ds = new VirtuosoDataSource();
        ds.setServerName(config.getServerName());
        ds.setUser(config.getUsername());
        ds.setPassword(config.getPassword());
        ds.setPortNumber(config.getPort());
        Connection conn = ds.getConnection();
        VirtuosoJdbcSparulExecutor executor = new VirtuosoJdbcSparulExecutor(conn, null);
        TBoxTripleDestination destination = new TBoxTripleDestination(executor, config.getDataGraphName(), config.getMetaGraphName(), config.getReifierPrefix());
        TBoxExtractor2 extractor = new TBoxExtractor2(tmp, config.getBaseUri(), config.getRootPrefix(), config.getExpressionPrefix(), destination);
        String mappingsOAIUri = "http://mappings.dbpedia.org/index.php/Special:OAIRepository";
        Iterator<Document> recordIterator = OAIUtil.createEndlessRecordIterator(mappingsOAIUri, startDate, 0L, config.getPollInterval() * 1000, config.getSleepInterval() * 1000);
        OntologyUpdateFeeder feeder = new OntologyUpdateFeeder(recordIterator, extractor, lastResponseDateFile);
        feeder.run();
    }

    public OntologyUpdateFeeder(Iterator<Document> recordIterator, TBoxExtractor2 extractor, File lastResponseDateFile) {
        this.recordIterator = recordIterator;
        this.extractor = extractor;
        this.lastResponseDateFile = lastResponseDateFile;
    }

    @Override
    public void run() {
        try {
            this._run();
        }
        catch (Exception e) {
            logger.error("Something went wrong", (Throwable)e);
        }
    }

    public void _run() throws Exception {
        Pattern oaiPattern = Pattern.compile("<identifier>(.*)</identifier>", 8);
        OntologyReader reader = new OntologyReader();
        while (this.recordIterator.hasNext()) {
            try {
                Document doc = this.recordIterator.next();
                String str = XMLUtil.toString(doc);
                if (str.contains("header status=\"deleted\"")) {
                    Matcher matcher = oaiPattern.matcher(str);
                    if (matcher.find()) {
                        String oaiId = matcher.group(1);
                        Resource oai = ResourceFactory.createResource((String)oaiId);
                        this.extractor.delete(oai);
                    }
                } else {
                    Node element = XML.loadString((String)str);
                    Source source = XMLSource.fromOAIXML((Elem)((Elem)element));
                    this.extractor.handle(source);
                }
                String timeStamp = XPathUtil.evalToString((org.w3c.dom.Node)doc, DBPediaXPathUtil.getOAIDatestampExpr());
                Files.createFile(this.lastResponseDateFile, timeStamp);
            }
            catch (Exception exp) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)exp));
            }
        }
    }
}

