/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.feeder.ITripleGenerator;
import org.dbpedia.extraction.live.feeder.MyVocabulary;
import org.dbpedia.extraction.live.feeder.RDFExpression;
import org.dbpedia.extraction.live.feeder.RDFUtil;
import org.dbpedia.extraction.live.feeder.StringReference;
import org.dbpedia.extraction.live.util.StringUtil;

class MosTripleGenerator
implements ITripleGenerator {
    private static Logger logger = Logger.getLogger(MosTripleGenerator.class);
    private StringReference exprPrefixRef;
    private PrefixMapping prefixResolver;

    public MosTripleGenerator(StringReference exprPrefixRef, PrefixMapping prefixResolver) {
        this.exprPrefixRef = exprPrefixRef;
        this.prefixResolver = prefixResolver;
    }

    @Override
    public Model generate(Model result, Resource subject, Property property, String value, String lang) throws Exception {
        if ((value = value.trim()).isEmpty()) {
            return result;
        }
        try {
            RDFExpression expr = RDFUtil.interpretMos(value, this.prefixResolver, this.exprPrefixRef.getValue(), false);
            if (expr.getRootSubject() == null) {
                return result;
            }
            Resource o = expr.getRootSubject();
            result.add(expr.getTriples());
            result.add(subject, property, (RDFNode)o);
        }
        catch (Exception e) {
            String msg = "Errornous expression for predicate '" + property.toString() + "': " + StringUtil.cropString(value.trim(), 50, 20);
            result.add(subject, MyVocabulary.DBM_ERROR, (RDFNode)result.createLiteral(msg));
            logger.warn((Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return result;
    }
}

