/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import com.hp.hpl.jena.shared.PrefixMapping;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxEditorParser;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class ManchesterParse {
    public static OWLClassExpression parse(String text, String base, PrefixMapping prefixResolver) {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLDataFactory dataFactory = manager.getOWLDataFactory();
            StupidEntityChecker checker = new StupidEntityChecker(manager.getOWLDataFactory(), base, prefixResolver);
            ManchesterOWLSyntaxEditorParser parser = new ManchesterOWLSyntaxEditorParser(dataFactory, text);
            parser.setBase(base);
            parser.setOWLEntityChecker((OWLEntityChecker)checker);
            return parser.parseClassExpression();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static class StupidEntityChecker
    implements OWLEntityChecker {
        private OWLDataFactory factory;
        private PrefixMapping resolver;

        public StupidEntityChecker(OWLDataFactory factory, String base, PrefixMapping resolver) {
            this.factory = factory;
            this.resolver = resolver;
        }

        public OWLClass getOWLClass(String name) {
            String expanded;
            IRI iri;
            String prefix = "";
            String className = name;
            String[] parts = name.split(":", 2);
            if (parts.length == 2) {
                prefix = parts[0].trim();
                className = parts[1].trim();
            }
            if ((prefix.equals("xsd") || Character.isUpperCase(className.toCharArray()[0])) && (iri = IRI.create((String)(expanded = this.resolver.expandPrefix(name)))) != null) {
                return this.factory.getOWLClass(iri);
            }
            return null;
        }

        public OWLObjectProperty getOWLObjectProperty(String name) {
            String expanded;
            IRI iri;
            String prefix = "";
            String className = name;
            String[] parts = name.split(":", 2);
            if (parts.length == 2) {
                prefix = parts[0].trim();
                className = parts[1].trim();
            }
            if (!prefix.equals("xsd") && !Character.isUpperCase(className.toCharArray()[0]) && (iri = IRI.create((String)(expanded = this.resolver.expandPrefix(name)))) != null) {
                return this.factory.getOWLObjectProperty(iri);
            }
            return null;
        }

        public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
            return null;
        }

        public OWLDataProperty getOWLDataProperty(String name) {
            return null;
        }

        public OWLDatatype getOWLDatatype(String name) {
            return null;
        }

        public OWLNamedIndividual getOWLIndividual(String name) {
            return null;
        }
    }
}

