/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.feeder;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.queue.LiveQueue;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.queue.LiveQueuePriority;
import org.dbpedia.extraction.live.util.ExceptionUtil;
import org.dbpedia.extraction.live.util.Files;

public abstract class Feeder
extends Thread {
    protected static Logger logger;
    protected String feederName;
    protected LiveQueuePriority queuePriority;
    protected String defaultStartTime;
    protected File latestProcessDateFile;
    protected String latestProcessDate;
    private volatile boolean keepRunning = true;

    public Feeder(String feederName, LiveQueuePriority queuePriority, String defaultStartTime, String folderBasePath) {
        this.feederName = feederName;
        this.setName("Feeder_" + feederName);
        logger = Logger.getLogger((String)feederName);
        this.queuePriority = queuePriority;
        this.defaultStartTime = defaultStartTime;
        this.latestProcessDateFile = new File(folderBasePath + feederName + ".dat");
        this.getLatestProcessedDate();
    }

    public LiveQueuePriority getQueuePriority() {
        return this.queuePriority;
    }

    public void startFeeder() {
        if (this.keepRunning) {
            this.start();
        }
    }

    public void stopFeeder(String date) {
        this.keepRunning = false;
        this.setLatestProcessedDate(date);
    }

    public String getLatestProcessedDate() {
        this.latestProcessDate = this.defaultStartTime;
        try {
            if (!this.latestProcessDateFile.exists()) {
                this.setLatestProcessedDate(this.defaultStartTime);
            } else {
                this.latestProcessDate = Files.readFile(this.latestProcessDateFile).trim();
            }
        }
        catch (Exception exp) {
            logger.error((Object)ExceptionUtil.toString(exp));
        }
        if (this.latestProcessDate.isEmpty()) {
            this.latestProcessDate = this.defaultStartTime;
            this.setLatestProcessedDate(this.latestProcessDate);
        }
        logger.warn((Object)("Resuming from date: " + this.latestProcessDate));
        return this.latestProcessDate;
    }

    public synchronized void setLatestProcessedDate(String date) {
        if (date == null || date.equals("")) {
            date = this.latestProcessDate;
        }
        Files.createFile(this.latestProcessDateFile, date);
    }

    protected abstract List<LiveQueueItem> getNextItems();

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                for (LiveQueueItem item : this.getNextItems()) {
                    this.handleFeedItem(item);
                }
            }
            catch (Exception exp) {
                logger.error((Object)ExceptionUtil.toString(exp));
            }
        }
    }

    protected void handleFeedItem(LiveQueueItem item) {
        this.addPageIDtoQueue(item);
    }

    protected void addPageIDtoQueue(LiveQueueItem item) {
        item.setStatQueueAdd(-1L);
        item.setPriority(this.queuePriority);
        LiveQueue.add(item);
        this.latestProcessDate = item.getModificationDate();
    }
}

