/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.extraction;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dbpedia.extraction.destinations.CompositeLiveDestination;
import org.dbpedia.extraction.destinations.ExtractorRestrictDestination;
import org.dbpedia.extraction.destinations.JSONCacheExtractorDestination;
import org.dbpedia.extraction.destinations.JSONCacheUpdateDestination;
import org.dbpedia.extraction.destinations.LiveDestination;
import org.dbpedia.extraction.destinations.LoggerDestination;
import org.dbpedia.extraction.destinations.PublisherDiffDestination;
import org.dbpedia.extraction.destinations.Quad;
import org.dbpedia.extraction.destinations.SPARULDestination;
import org.dbpedia.extraction.destinations.formatters.UriPolicy$;
import org.dbpedia.extraction.live.core.LiveOptions;
import org.dbpedia.extraction.live.extractor.LiveExtractor$;
import org.dbpedia.extraction.live.helper.ExtractorStatus;
import org.dbpedia.extraction.live.helper.LiveConfigReader;
import org.dbpedia.extraction.live.queue.LiveQueueItem;
import org.dbpedia.extraction.live.storage.JSONCache;
import org.dbpedia.extraction.live.storage.JSONCache$;
import org.dbpedia.extraction.mappings.Extractor;
import org.dbpedia.extraction.mappings.RootExtractor;
import org.dbpedia.extraction.sources.Source;
import org.dbpedia.extraction.sources.WikiSource$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.Namespace$;
import org.dbpedia.extraction.wikiparser.PageNode;
import org.dbpedia.extraction.wikiparser.impl.simple.SimpleWikiParser;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Traversable$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.StringAdd$;

public final class LiveExtractionConfigLoader$ {
    public static final LiveExtractionConfigLoader$ MODULE$;
    private int instanceNumber;
    private List<RootExtractor> org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors;
    private boolean reloadOntologyAndMapping;
    private long ontologyAndMappingsUpdateTime;
    private final Logger logger;
    private final Source ontologySource;
    private final Source mappingsSource;
    private final Null$ commonsSource;
    private final Function1<URI, URI>[] policies;

    static {
        new LiveExtractionConfigLoader$();
    }

    private int instanceNumber() {
        return this.instanceNumber;
    }

    private void instanceNumber_$eq(int x$1) {
        this.instanceNumber = x$1;
    }

    public List<RootExtractor> org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors() {
        return this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors;
    }

    private void org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors_$eq(List<RootExtractor> x$1) {
        this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors = x$1;
    }

    private boolean reloadOntologyAndMapping() {
        return this.reloadOntologyAndMapping;
    }

    private void reloadOntologyAndMapping_$eq(boolean x$1) {
        this.reloadOntologyAndMapping = x$1;
    }

    private long ontologyAndMappingsUpdateTime() {
        return this.ontologyAndMappingsUpdateTime;
    }

    private void ontologyAndMappingsUpdateTime_$eq(long x$1) {
        this.ontologyAndMappingsUpdateTime = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public Source ontologySource() {
        return this.ontologySource;
    }

    public Source mappingsSource() {
        return this.mappingsSource;
    }

    public Null$ commonsSource() {
        return this.commonsSource;
    }

    public Function1<URI, URI>[] policies() {
        return this.policies;
    }

    public void reload(long t) {
        if (t > this.ontologyAndMappingsUpdateTime()) {
            this.reloadOntologyAndMapping_$eq(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private File getDumpFile(File dumpDir, String wikiPrefix) {
        void var3_3;
        File wikiDir = new File(new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)dumpDir), "/")).append((Object)wikiPrefix).toString());
        if (wikiDir.isDirectory()) {
            void var5_5;
            String date = (String)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])wikiDir.list()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return x$1.matches("\\d{8}");
                }
            })).sortWith((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$2, String x$3) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt() > new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
                }
            })).headOption().getOrElse((Function0)new Serializable(wikiPrefix){
                public static final long serialVersionUID = 0L;
                private final String wikiPrefix$1;

                public final Nothing$ apply() {
                    throw new Exception(new StringBuilder().append((Object)"No dump found for Wiki: ").append((Object)this.wikiPrefix$1).toString());
                }
                {
                    this.wikiPrefix$1 = wikiPrefix$1;
                }
            });
            File articlesDump = new File(new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)wikiDir), "/")).append((Object)date).append((Object)"/").append((Object)wikiPrefix.replace('-', '_')).append((Object)"wiki-").append((Object)date).append((Object)"-pages-articles.xml").toString());
            if (articlesDump.isFile()) {
                return articlesDump;
            }
            throw new Exception(new StringBuilder().append((Object)"Dump not found: ").append((Object)var5_5).toString());
        }
        throw new Exception(new StringBuilder().append((Object)"Dump directory not found: ").append((Object)var3_3).toString());
    }

    public boolean extractPage(LiveQueueItem item, String apiURL, String landCode) {
        Language lang = Language$.MODULE$.apply(landCode);
        Source articlesSource = WikiSource$.MODULE$.fromPageIDs((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{item.getItemID()})), new URL(apiURL), lang);
        return this.startExtraction(articlesSource, lang);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startExtraction(Source articlesSource, Language language) {
        BoxedUnit boxedUnit;
        if (this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors() == null || this.reloadOntologyAndMapping()) {
            LiveExtractionConfigLoader$ liveExtractionConfigLoader$ = this;
            synchronized (liveExtractionConfigLoader$) {
                BoxedUnit boxedUnit2;
                if (this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors() == null || this.reloadOntologyAndMapping()) {
                    this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors_$eq(this.LoadOntologyAndMappings(articlesSource, language));
                    this.logger().log(Level.INFO, "Ontology and mappings reloaded");
                    this.reloadOntologyAndMapping_$eq(false);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl13 : MonitorExitStatement: MONITOREXIT : liveExtractionConfigLoader$
                boxedUnit = boxedUnit3;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleWikiParser parser = new SimpleWikiParser();
        BooleanRef complete = new BooleanRef(false);
        ((GenericTraversableTemplate)articlesSource.map((Function1)parser, Traversable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(language, complete){
            public static final long serialVersionUID = 0L;
            private final Language language$1;
            private final BooleanRef complete$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(PageNode cpage) {
                block3: {
                    block2: {
                        Namespace namespace = cpage.title().namespace();
                        Namespace namespace2 = Namespace$.MODULE$.Main();
                        if (!(namespace == null ? namespace2 != null : !namespace.equals(namespace2))) break block2;
                        Namespace namespace3 = cpage.title().namespace();
                        Namespace namespace4 = Namespace$.MODULE$.Template();
                        if (!(namespace3 == null ? namespace4 != null : !namespace3.equals(namespace4))) break block2;
                        Namespace namespace5 = cpage.title().namespace();
                        Namespace namespace6 = Namespace$.MODULE$.Category();
                        if (namespace5 != null ? !namespace5.equals(namespace6) : namespace6 != null) break block3;
                    }
                    JSONCache liveCache = new JSONCache(cpage.id(), cpage.title().decoded());
                    ArrayBuffer destList = new ArrayBuffer();
                    destList.$plus$eq((Object)new SPARULDestination(true, LiveExtractionConfigLoader$.MODULE$.policies()));
                    destList.$plus$eq((Object)new SPARULDestination(false, LiveExtractionConfigLoader$.MODULE$.policies()));
                    destList.$plus$eq((Object)new JSONCacheUpdateDestination(liveCache));
                    destList.$plus$eq((Object)new PublisherDiffDestination(LiveExtractionConfigLoader$.MODULE$.policies()));
                    destList.$plus$eq((Object)new LoggerDestination(cpage.id(), cpage.title().decoded()));
                    CompositeLiveDestination compositeDest = new CompositeLiveDestination((Seq<LiveDestination>)destList.toSeq());
                    JSONCacheExtractorDestination extractorDiffDest = new JSONCacheExtractorDestination(liveCache, compositeDest);
                    ExtractorRestrictDestination extractorRestrictDest = new ExtractorRestrictDestination(LiveConfigReader.extractors.get(Language$.MODULE$.apply(this.language$1.isoCode())), extractorDiffDest);
                    extractorRestrictDest.open();
                    LiveExtractionConfigLoader$.MODULE$.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors().foreach((Function1)new Serializable(this, cpage, extractorRestrictDest){
                        public static final long serialVersionUID = 0L;
                        private final PageNode cpage$1;
                        private final ExtractorRestrictDestination extractorRestrictDest$1;

                        public final void apply(RootExtractor extractor) {
                            Seq seq;
                            try {
                                seq = extractor.apply(this.cpage$1);
                            }
                            catch (Exception exception) {
                                LiveExtractionConfigLoader$.MODULE$.logger().log(Level.FINE, new StringBuilder().append((Object)"Error in ").append((Object)extractor.extractor().getClass().getName()).append((Object)"\nError Message: ").append((Object)exception.getMessage()).toString(), exception);
                                seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                            }
                            Seq RequiredGraph = seq;
                            this.extractorRestrictDest$1.write(extractor.extractor().getClass().getName(), "", (Seq<Quad>)RequiredGraph, (Seq<Quad>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Seq<Quad>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
                        }
                        {
                            this.cpage$1 = cpage$1;
                            this.extractorRestrictDest$1 = extractorRestrictDest$1;
                        }
                    });
                    extractorRestrictDest.close();
                    this.complete$1.elem = true;
                    return;
                }
                JSONCache$.MODULE$.deleteCacheOnlyItem(cpage.id());
            }
            {
                this.language$1 = language$1;
                this.complete$1 = complete$1;
            }
        });
        return complete.elem;
    }

    private List<RootExtractor> LoadOntologyAndMappings(Source articlesSource, Language language) {
        this.ontologyAndMappingsUpdateTime_$eq(System.currentTimeMillis());
        List<Class<Extractor>> extractorClasses = this.convertExtractorListToScalaList(LiveConfigReader.getExtractors(language, ExtractorStatus.ACTIVE));
        Source source = this.ontologySource();
        Source source2 = this.mappingsSource();
        this.commonsSource();
        return LiveExtractor$.MODULE$.load(source, source2, articlesSource, null, extractorClasses, language);
    }

    /*
     * WARNING - void declaration
     */
    private List<Class<Extractor>> convertExtractorListToScalaList(java.util.List<Class<Extractor>> list) {
        void var2_2;
        Nil$ extractorList = Nil$.MODULE$;
        Iterator<Class<Extractor>> listiterator = list.iterator();
        while (listiterator.hasNext()) {
            Nil$ nil$ = extractorList;
            extractorList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{listiterator.next()})).$colon$colon$colon((List)nil$);
        }
        Predef$.MODULE$.println((Object)extractorList);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<Language, List<Class<Extractor>>> convertExtractorMapToScalaMap(Map<Language, java.util.List<Class<Extractor>>> map) {
        void var2_2;
        scala.collection.immutable.Map extractorMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        for (Map.Entry<Language, java.util.List<Class<Extractor>>> pairs : map.entrySet()) {
            extractorMap = extractorMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)pairs.getKey()), this.convertExtractorListToScalaList(pairs.getValue())));
        }
        Predef$.MODULE$.println((Object)extractorMap);
        return var2_2;
    }

    private LiveExtractionConfigLoader$() {
        MODULE$ = this;
        this.instanceNumber = 0;
        this.org$dbpedia$extraction$live$extraction$LiveExtractionConfigLoader$$extractors = null;
        this.reloadOntologyAndMapping = true;
        this.ontologyAndMappingsUpdateTime = 0L;
        this.logger = Logger.getLogger("LiveExtractionConfigLoader");
        this.ontologySource = WikiSource$.MODULE$.fromNamespaces((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{Namespace$.MODULE$.OntologyClass(), Namespace$.MODULE$.OntologyProperty()})), new URL(Language$.MODULE$.Mappings().apiUri()), Language$.MODULE$.Mappings());
        this.mappingsSource = WikiSource$.MODULE$.fromNamespaces((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{(Namespace)Namespace$.MODULE$.mappings().apply((Object)Language$.MODULE$.apply((String)LiveOptions.options.get((Object)"language")))})), new URL(Language$.MODULE$.Mappings().apiUri()), Language$.MODULE$.Mappings());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"COMMONS SOURCE = ").append(LiveOptions.options.get((Object)"commonsDumpsPath")).toString());
        this.commonsSource = null;
        this.policies = UriPolicy$.MODULE$.parsePolicy((String)LiveOptions.options.get((Object)"uri-policy.main"));
    }
}

