/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.core;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLConverter {
    private static Logger logger = null;
    protected HashMap _namespaces = new HashMap();

    public static void init() {
        try {
            logger = Logger.getLogger((String)Class.forName("XMLConverter").getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void detectNamespacesFromDocument(Document document) {
        NodeList nodes = document.getElementsByTagNameNS("*", "*");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (this._namespaces.get(node.getPrefix()) != null) continue;
            this._namespaces.put(node.getPrefix(), node.getNamespaceURI());
        }
    }

    public HashMap toArray(String xmlSparqlResults) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xmlDoc = builder.parse(new InputSource(new StringReader(xmlSparqlResults)));
            xmlDoc.normalize();
            this.detectNamespacesFromDocument(xmlDoc);
            ArrayList<String> vars = new ArrayList<String>();
            ArrayList bindings = new ArrayList();
            Node root = xmlDoc.getFirstChild();
            Node set = root.getFirstChild();
            NodeList setChildNodes = set.getChildNodes();
            for (int i = 0; i < setChildNodes.getLength(); ++i) {
                Node node = setChildNodes.item(i);
                if (!node.hasChildNodes()) continue;
                HashMap row = new HashMap();
                NodeList nodeChildList = node.getChildNodes();
                for (int j = 0; j < nodeChildList.getLength(); ++j) {
                    HashMap datatypeHashMap;
                    HashMap<String, String> tempHashmap;
                    Node binding = nodeChildList.item(j);
                    if (!(binding instanceof Element)) continue;
                    Attr attrKey = ((Element)binding).getAttributeNodeNS(this._namespaces.get("rs").toString(), "name");
                    Element nodeValue = (Element)binding.getFirstChild();
                    String dataKey = attrKey.getValue();
                    if (!vars.contains(dataKey)) {
                        vars.add(dataKey);
                    }
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    NamedNodeMap nodeAttributeList = nodeValue.getAttributes();
                    for (int k = 0; k < nodeAttributeList.getLength(); ++k) {
                        Node attribute = nodeAttributeList.item(i);
                        attributes.put(attribute.getNodeName(), attribute.getNodeValue());
                    }
                    if (attributes.containsKey("resource")) {
                        tempHashmap = new HashMap<String, String>();
                        tempHashmap.put("value", nodeValue.getAttributeNodeNS(this._namespaces.get("rdf").toString(), "resource").getValue());
                        tempHashmap.put("type", "uri");
                        row.put(dataKey, tempHashmap);
                        continue;
                    }
                    if (attributes.containsKey("nodeID")) {
                        tempHashmap = new HashMap();
                        tempHashmap.put("value", nodeValue.getAttributeNodeNS(this._namespaces.get("rdf").toString(), "nodeID").getValue());
                        tempHashmap.put("type", "bnode");
                        row.put(dataKey, tempHashmap);
                        continue;
                    }
                    Attr lang = nodeValue.getAttributeNodeNS(this._namespaces.get("xml").toString(), "lang");
                    Attr datatype = nodeValue.getAttributeNodeNS(this._namespaces.get("rdf").toString(), "datatype");
                    HashMap<String, String> tempHashmap2 = new HashMap<String, String>();
                    tempHashmap2.put("value", nodeValue.getTextContent());
                    tempHashmap2.put("type", datatype.getValue());
                    row.put(dataKey, tempHashmap2);
                    if (datatype != null) {
                        datatypeHashMap = (HashMap)row.get(dataKey);
                        datatypeHashMap.put("datatype", datatype.getValue().toString());
                    }
                    if (lang == null) continue;
                    datatypeHashMap = (HashMap)row.get(dataKey);
                    datatypeHashMap.put("xml:lang", lang.getValue().toString());
                }
                bindings.add(row);
            }
            HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
            HashMap<String, ArrayList<String>> varsHashMap = new HashMap<String, ArrayList<String>>();
            varsHashMap.put("vars", vars);
            result.put("head", varsHashMap);
            result.put("bindings", bindings);
            return result;
        }
        catch (Exception exp) {
            logger.error((Object)exp.getMessage());
            return null;
        }
    }
}

