/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.core.Constants;

public class Util {
    private static Logger logger = null;
    public static HashMap<String, HashMap<String, String>> MEDIAWIKI_NAMESPACES = null;

    public static String deck(String in, int space) {
        String w = StringUtils.repeat((String)"&nbsp;", (int)space);
        return "<td>" + w + in + w + "</td>";
    }

    public static String deck(String in) {
        return Util.deck(in, 0);
    }

    public static String row(String in, int space) {
        String w = StringUtils.repeat((String)"&nbsp;", (int)space);
        return "<td>" + w + in + w + "</td>" + "\n";
    }

    public static String row(String in) {
        return Util.row(in, 0);
    }

    private static String escape(String str) {
        StringBuffer resultingString = new StringBuffer();
        Pattern regex = Pattern.compile("/[\\x00-\\x1F\\x22\\x5C\\x7F]|[\\x80-\\xBF]|[\\xC0-\\xFF][\\x80-\\xBF]*/");
        Matcher regexMatcher = regex.matcher(str);
        while (regexMatcher.find()) {
            MatchResult matchResult = regexMatcher.toMatchResult();
            String strMatch = matchResult.group(0);
            String replacementString = "";
            String encoded_character = strMatch.toString();
            byte Byte2 = (byte)encoded_character.charAt(0);
            byte codepoint = 0;
            int Bytes = 0;
            if (Byte2 == 9) {
                replacementString = "\\t";
            }
            if (Byte2 == 10) {
                replacementString = "\\n";
            }
            if (Byte2 == 13) {
                replacementString = "\\r";
            }
            if (Byte2 == 34) {
                replacementString = "\\\"";
            }
            if (Byte2 == 92) {
                replacementString = "\\\\";
            }
            if (Byte2 < 32 || Byte2 == 127) {
                replacementString = "\\u00" + String.format("%02X", Byte2);
            }
            if (Byte2 < 192) {
                replacementString = "\\uFFFD";
            }
            if (Byte2 < 224) {
                Bytes = 2;
                codepoint = (byte)(Byte2 & 0x1F);
            } else if (Byte2 < 240) {
                Bytes = 3;
                codepoint = (byte)(Byte2 & 0xF);
            } else if (Byte2 < 248) {
                Bytes = 4;
                codepoint = (byte)(Byte2 & 7);
            } else if (Byte2 < 252) {
                Bytes = 5;
                codepoint = (byte)(Byte2 & 3);
            } else if (Byte2 < 254) {
                Bytes = 6;
                codepoint = (byte)(Byte2 & 1);
            } else {
                replacementString = "\\uFFFD";
            }
            int length = encoded_character.length();
            if (length < Bytes) {
                replacementString = "\\uFFFD";
            }
            String rest = "";
            rest = length > Bytes ? StringUtils.repeat((String)"\\uFFFD", (int)(length - Bytes)) : "";
            for (int i = 0; i < Bytes; i = (int)((byte)(i + 1))) {
                Byte2 = (byte)encoded_character.charAt(i);
                codepoint = (byte)(codepoint << 6 | Byte2 & 0x3F);
            }
            if (Bytes == 2 && codepoint <= 127 || Bytes == 3 && codepoint <= 2047 || Bytes == 4 && codepoint <= 65535 || Bytes == 5 && codepoint <= 0x1FFFFF || Bytes == 6 && codepoint <= 0x3FFFFF) {
                replacementString = "\\uFFFD" + rest;
            }
            if (codepoint >= 55296 && codepoint <= 57343) {
                replacementString = "\\uFFFD" + rest;
            }
            if (codepoint == 65534 || codepoint == 65535) {
                replacementString = "\\uFFFD" + rest;
            }
            if (codepoint <= 65535) {
                replacementString = "\\u" + String.format("%04X", codepoint) + rest;
            }
            if (codepoint <= 0x10FFFF) {
                replacementString = "\\U" + String.format("%08X", codepoint) + rest;
            }
            replacementString = "\\uFFFD" + rest;
            regexMatcher.appendReplacement(resultingString, replacementString);
        }
        regexMatcher.appendTail(resultingString);
        return resultingString.toString();
    }

    public static boolean isStringNullOrEmpty(String str) {
        return str == null || str.equals("");
    }

    public static String getDBpediaCategoryPrefix(String language) {
        try {
            return Constants.DB_RESOURCE_NS + URLEncoder.encode(Util._getMediaWikiNamespace(language, "Category"), "UTF-8") + ':';
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMediaWikiCategoryNamespace(String language) {
        return Util._getMediaWikiNamespace(language, "Category");
    }

    public static String getMediaWikiNamespace(String language, String what) {
        return Util._getMediaWikiNamespace(language, what);
    }

    private static String _getMediaWikiNamespace(String language, String what) {
        if (MEDIAWIKI_NAMESPACES == null) {
            MEDIAWIKI_NAMESPACES = new HashMap();
        }
        if (MEDIAWIKI_NAMESPACES.get("legal").get(what) == null) {
            logger.error((Object)("no namespace for " + what + " illegal use, does not exist"));
        }
        if (MEDIAWIKI_NAMESPACES.get(language) == null) {
            logger.warn((Object)("namespaces not set in core/language_namespaces for: " + language));
            MEDIAWIKI_NAMESPACES.put(language, new HashMap());
        }
        if (MEDIAWIKI_NAMESPACES.get(language).get(what) == null) {
            logger.warn((Object)("no namespace for " + what + " in language: " + language + " in core/language_namespaces using english instead of: " + language));
            String valueForEnglishLanguage = MEDIAWIKI_NAMESPACES.get("en").get(what);
            MEDIAWIKI_NAMESPACES.get(language).put(what, valueForEnglishLanguage);
        }
        return MEDIAWIKI_NAMESPACES.get(language).get(what);
    }

    static {
        try {
            logger = Logger.getLogger((String)Util.class.getName());
            MEDIAWIKI_NAMESPACES = new HashMap();
            HashMap<String, String> legalHashmap = new HashMap<String, String>();
            legalHashmap.put("Category", "");
            legalHashmap.put("Template", "");
            legalHashmap.put("File", "");
            legalHashmap.put("FileAlt", "");
            MEDIAWIKI_NAMESPACES.put("legal", legalHashmap);
            HashMap<String, String> englishHashmap = new HashMap<String, String>();
            englishHashmap.put("Category", "Category");
            englishHashmap.put("Template", "Template");
            englishHashmap.put("File", "File");
            englishHashmap.put("FileAlt", "Image");
            MEDIAWIKI_NAMESPACES.put("en", englishHashmap);
            HashMap<String, String> germanHashmap = new HashMap<String, String>();
            germanHashmap.put("Category", "Kategorie");
            germanHashmap.put("Template", "Template");
            germanHashmap.put("File", "Datei");
            germanHashmap.put("FileAlt", "Bild");
            MEDIAWIKI_NAMESPACES.put("de", germanHashmap);
            HashMap<String, String> greekHashmap = new HashMap<String, String>();
            greekHashmap.put("Category", "\u039a\u03b1\u03c4\u03b7\u03b3\u03bf\u03c1\u03af\u03b1");
            greekHashmap.put("Template", "\u03a0\u03c1\u03cc\u03c4\u03c5\u03c0\u03bf");
            greekHashmap.put("File", "\u0391\u03c1\u03c7\u03b5\u03af\u03bf");
            greekHashmap.put("FileAlt", "\u0395\u03b9\u03ba\u03cc\u03bd\u03b1");
            MEDIAWIKI_NAMESPACES.put("el", greekHashmap);
            HashMap<String, String> koreanHashmap = new HashMap<String, String>();
            koreanHashmap.put("Category", "??");
            koreanHashmap.put("Template", "?");
            koreanHashmap.put("File", "??");
            koreanHashmap.put("FileAlt", "??");
            MEDIAWIKI_NAMESPACES.put("ko", koreanHashmap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

