/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.live.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dbpedia.extraction.live.core.Util;

public class Timer {
    private static Logger logger = Logger.getLogger(Timer.class);
    public static HashMap time = new HashMap();
    public static HashMap start = new HashMap();
    public static long startingTime;

    public static void init() {
        startingTime = System.nanoTime();
    }

    public static long getElapsedSeconds() {
        return System.nanoTime() - startingTime;
    }

    public static String timerLabel(String component, Object obj, String rest) {
        return component + "." + obj.getClass().toString() + "." + rest;
    }

    public static void start(String TimerName) {
        try {
            if (start.get(TimerName) != null) {
                // empty if block
            }
            start.put(TimerName, System.nanoTime());
        }
        catch (Exception exp) {
            logger.error((Object)("Cannot start timer \"" + TimerName + "\""));
        }
    }

    public static void staticTimer(String name, long timeToAdd) {
        Timer.check(name);
        HashMap hmTotal = (HashMap)time.get(name);
        long CurrentTotal = Long.parseLong(hmTotal.get("total").toString());
        hmTotal.put("total", CurrentTotal + timeToAdd);
        int CurrentHits = Integer.parseInt(hmTotal.get("hits").toString());
        hmTotal.put("hits", CurrentHits + 1);
    }

    public static long stop(String TimerName) {
        if (start.get(TimerName) == null) {
            logger.warn((Object)("Timer: " + TimerName + " was never started. ignoring"));
            return -1L;
        }
        long before = Long.parseLong(start.get(TimerName).toString());
        start.remove(TimerName);
        long TimeNeeded = System.nanoTime() - before;
        Timer.check(TimerName);
        HashMap CurrentMap = (HashMap)time.get(TimerName);
        long CurrentTotal = Long.parseLong(CurrentMap.get("total").toString());
        CurrentMap.put("total", CurrentTotal + TimeNeeded);
        int CurrentHits = Integer.parseInt(CurrentMap.get("hits").toString());
        CurrentMap.put("hits", CurrentHits + 1);
        return TimeNeeded;
    }

    public static String stopAsString(String TimerName) {
        long TimeElapsed = Timer.stop(TimerName);
        return ", needed: " + Math.round(TimeElapsed * 1000L) + " ms";
    }

    private static void check(String TimerName) {
        if (time.get(TimerName) == null) {
            time.put(TimerName, new HashMap());
            HashMap CurrentMap = (HashMap)time.get(TimerName);
            CurrentMap.put("total", 0);
            CurrentMap.put("hits", 0);
        }
    }

    public static void writeTimeToFile(String statisticsDirectory) throws SecurityException {
        try {
            HashMap<String, Long> Overall = new HashMap<String, Long>();
            Overall.put("startingtime", startingTime);
            Overall.put("lasttime", System.nanoTime());
            boolean bDirectoryCreated = new File(statisticsDirectory).mkdirs();
            if (!bDirectoryCreated) {
                throw new SecurityException("Program unable to create the specified directory");
            }
            if (bDirectoryCreated) {
                FileOutputStream File1 = new FileOutputStream(statisticsDirectory + "/time.ser");
                FileOutputStream File2 = new FileOutputStream(statisticsDirectory + "/timeOverall.ser");
                ObjectOutputStream Serializer1 = new ObjectOutputStream(File1);
                ObjectOutputStream Serializer2 = new ObjectOutputStream(File2);
                Serializer1.writeObject(time);
                Serializer2.writeObject(Overall);
                File1.close();
                File2.close();
            } else {
                logger.warn((Object)"Statistic directory cannot be created");
            }
        }
        catch (Exception exp) {
            logger.warn((Object)exp.getMessage());
        }
    }

    public static void printTime() {
        Timer.printTime(2);
    }

    public static void printTime(int precision) {
        String Message = Timer.getTimeAsString(precision);
        if (start.size() > 0) {
            logger.warn((Object)"Timer: Unfinished timers:");
            Set KeySet2 = start.keySet();
            Iterator KeySetIterator = KeySet2.iterator();
            while (KeySetIterator.hasNext()) {
                logger.warn((Object)("Timer: " + KeySetIterator.next()));
            }
        }
        logger.info((Object)Message);
    }

    static String getTimeAsString() {
        return Timer.getTimeAsString(2);
    }

    static String getTimeAsString(int precision) {
        String Message = "";
        TreeMap SortedMap2 = new TreeMap(time);
        Set keys = SortedMap2.keySet();
        for (Integer key : keys) {
            HashMap value = (HashMap)SortedMap2.get(key);
            String tempString = "";
            long TotalAsLong = Long.parseLong(value.get("total").toString());
            long total = Math.round(TotalAsLong);
            String percent = Timer.getPercentage(TotalAsLong);
            Integer hits = Integer.parseInt(value.get("hits").toString());
            Double avg = Math.round(TotalAsLong * 1000L) / hits;
            tempString = tempString + Util.deck(Math.round(total) + " sec");
            tempString = tempString + Util.deck("" + percent + "");
            tempString = tempString + Util.deck(hits.toString());
            tempString = tempString + Util.deck(avg.toString());
            tempString = tempString + Util.deck(key.toString());
            Message = Message + Util.row(tempString, 0);
        }
        return Message;
    }

    private static String getPercentage(long componentTime) {
        long total = System.nanoTime() - startingTime;
        String result = Math.round(componentTime / total * 100L) + "%";
        return result;
    }
}

