/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.dump.extract;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.dbpedia.extraction.util.StringUtils$;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001b\t\u0011R\t\u001f;sC\u000e$\u0018n\u001c8Qe><'/Z:t\u0015\t\u0019A!A\u0004fqR\u0014\u0018m\u0019;\u000b\u0005\u00151\u0011\u0001\u00023v[BT!a\u0002\u0005\u0002\u0015\u0015DHO]1di&|gN\u0003\u0002\n\u0015\u00059AM\u00199fI&\f'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003\u0015a\u0017MY3m!\t9\"D\u0004\u0002\u00101%\u0011\u0011\u0004E\u0001\u0007!J,G-\u001a4\n\u0005ma\"AB*ue&twM\u0003\u0002\u001a!!Aa\u0004\u0001B\u0001B\u0003%a#A\u0006eKN\u001c'/\u001b9uS>t\u0007\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0002#I\u0015\u0002\"a\t\u0001\u000e\u0003\tAQ!F\u0010A\u0002YAQAH\u0010A\u0002YAqa\n\u0001C\u0002\u0013%\u0001&\u0001\u0004m_\u001e<WM]\u000b\u0002SA\u0011!&M\u0007\u0002W)\u0011A&L\u0001\bY><w-\u001b8h\u0015\tqs&\u0001\u0003vi&d'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e-\u0012a\u0001T8hO\u0016\u0014\bB\u0002\u001b\u0001A\u0003%\u0011&A\u0004m_\u001e<WM\u001d\u0011\t\u000fY\u0002!\u0019!C\u0005o\u0005I1\u000f^1siRKW.Z\u000b\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0007CR|W.[2\u000b\u0005uj\u0013AC2p]\u000e,(O]3oi&\u0011qH\u000f\u0002\u000b\u0003R|W.[2M_:<\u0007BB!\u0001A\u0003%\u0001(\u0001\u0006ti\u0006\u0014H\u000fV5nK\u0002Bqa\u0011\u0001C\u0002\u0013%A)\u0001\u0005bY2\u0004\u0016mZ3t+\u0005)\u0005CA\u001dG\u0013\t9%HA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\u0007\u0013\u0002\u0001\u000b\u0011B#\u0002\u0013\u0005dG\u000eU1hKN\u0004\u0003bB&\u0001\u0005\u0004%I\u0001R\u0001\fM\u0006LG.\u001a3QC\u001e,7\u000f\u0003\u0004N\u0001\u0001\u0006I!R\u0001\rM\u0006LG.\u001a3QC\u001e,7\u000f\t\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u0006gR\f'\u000f\u001e\u000b\u0002#B\u0011qBU\u0005\u0003'B\u0011A!\u00168ji\")Q\u000b\u0001C\u0001-\u0006I1m\\;oiB\u000bw-\u001a\u000b\u0003#^CQ\u0001\u0017+A\u0002e\u000bqa];dG\u0016\u001c8\u000f\u0005\u0002\u00105&\u00111\f\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015i\u0006\u0001\"\u0001Q\u0003\r)g\u000e\u001a\u0005\u0006?\u0002!\t\u0001U\u0001\u0004Y><\u0007")
public class ExtractionProgress {
    private final String label;
    private final String description;
    private final Logger logger;
    private final AtomicLong startTime;
    private final AtomicInteger allPages;
    private final AtomicInteger failedPages;

    private Logger logger() {
        return this.logger;
    }

    private AtomicLong startTime() {
        return this.startTime;
    }

    private AtomicInteger allPages() {
        return this.allPages;
    }

    private AtomicInteger failedPages() {
        return this.failedPages;
    }

    public void start() {
        this.startTime().set(System.currentTimeMillis());
        this.logger().info(new StringBuilder().append((Object)this.description).append((Object)" started").toString());
    }

    public void countPage(boolean success) {
        Object object = success ? BoxedUnit.UNIT : BoxesRunTime.boxToInteger((int)this.failedPages().incrementAndGet());
        if (this.allPages().incrementAndGet() % 2000 == 0) {
            this.log();
        }
    }

    public void end() {
        this.log();
        this.logger().info(new StringBuilder().append((Object)this.description).append((Object)" finished").toString());
    }

    public void log() {
        long time = System.currentTimeMillis() - this.startTime().get();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)this.label).append((Object)": extracted ").append((Object)BoxesRunTime.boxToInteger((int)this.allPages().get())).append((Object)" pages in ").append((Object)StringUtils$.MODULE$.prettyMillis(time)).append((Object)" (per page: ").append((Object)BoxesRunTime.boxToDouble((double)((double)time / (double)this.allPages().get()))).append((Object)" ms; failed pages: ").append((Object)BoxesRunTime.boxToInteger((int)this.failedPages().get())).append((Object)").").toString());
    }

    public ExtractionProgress(String label, String description) {
        this.label = label;
        this.description = description;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.startTime = new AtomicLong();
        this.allPages = new AtomicInteger();
        this.failedPages = new AtomicInteger();
    }
}

